/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.scrap;

import de.markusbordihn.scraptechworkshop.block.ScrapPileBlock;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.spawner.ScrapPileSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapPileDecay {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    private ScrapPileDecay() {
    }

    public static void handleDecay(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int currentSize = (Integer)blockState.m_61143_((Property)ScrapPileBlock.SIZE);
        ScrapPileVariant variant = (ScrapPileVariant)((Object)blockState.m_61143_(ScrapPileBlock.VARIANT));
        if (currentSize > 1) {
            serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)ScrapPileBlock.SIZE, (Comparable)Integer.valueOf(currentSize - 1)), 3);
            log.debug("Scrap pile aged at {} in dimension {} - Size reduced from {} to {}, Variant: {}", (Object)blockPos, (Object)serverLevel.m_46472_().m_135782_(), (Object)currentSize, (Object)(currentSize - 1), (Object)variant);
        } else {
            serverLevel.m_7471_(blockPos, false);
            try {
                ScrapPileSpawner.decrementChunkCount(new ChunkPos(blockPos));
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.debug("Scrap pile completely decayed at {} in dimension {} - Removed, Variant: {}", (Object)blockPos, (Object)serverLevel.m_46472_().m_135782_(), (Object)variant);
        }
    }
}

