/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogParser {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Gson GSON = new Gson();

    private HoloLogParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean holoLogExists(ResourceLocation id) {
        boolean bl;
        Minecraft minecraft = Minecraft.m_91087_();
        ResourceManager resourceManager = minecraft.m_91098_();
        ResourceLocation resourcePath = new ResourceLocation(id.m_135827_(), id.m_135815_() + ".json");
        Optional resource = resourceManager.m_213713_(resourcePath);
        if (!resource.isEmpty()) return resource.isPresent();
        String classpathPath = "/assets/" + id.m_135827_() + "/" + id.m_135815_() + ".json";
        InputStream stream = HoloLogParser.class.getResourceAsStream(classpathPath);
        try {
            boolean bl2 = bl = stream != null;
            if (stream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        stream.close();
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<HoloLogData> getHoloLog(ResourceLocation id) {
        block14: {
            try {
                Minecraft minecraft = Minecraft.m_91087_();
                ResourceManager resourceManager = minecraft.m_91098_();
                Optional resource = resourceManager.m_213713_(new ResourceLocation(id.m_135827_(), id.m_135815_() + ".json"));
                InputStream stream = null;
                if (resource.isPresent()) {
                    stream = ((Resource)resource.get()).m_215507_();
                    log.debug("Loaded hololog from ResourceManager: {}", (Object)id);
                } else {
                    String classpathPath = "/assets/" + id.m_135827_() + "/" + id.m_135815_() + ".json";
                    stream = HoloLogParser.class.getResourceAsStream(classpathPath);
                    if (stream != null) {
                        log.debug("Loaded hololog from classpath: {}", (Object)classpathPath);
                    } else {
                        log.error("Hololog not found: {}", (Object)id);
                    }
                }
                if (stream == null) break block14;
                try {
                    Optional<HoloLogData> optional;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        HoloLogData data = HoloLogData.fromJson(json);
                        HoloLogParser.validateLineLengths(data, id);
                        log.debug("Parsed hololog: {}", (Object)id);
                        optional = Optional.of(data);
                    }
                    return optional;
                }
                finally {
                    stream.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to load hololog {}: {}", (Object)id, (Object)e.getMessage(), (Object)e);
            }
        }
        return Optional.empty();
    }

    private static void validateLineLengths(HoloLogData data, ResourceLocation id) {
        int MAX_LINE_LENGTH = 57;
        for (int i = 0; i < data.lines().size(); ++i) {
            String text = data.lines().get(i).text();
            if (text == null || text.length() <= 57) continue;
            log.warn("Hololog '{}' line {} exceeds recommended length: {} characters (max {}): \"{}\"", (Object)id, (Object)(i + 1), (Object)text.length(), (Object)57, (Object)text);
        }
    }
}

