/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.multitool;

public enum ToolMode {
    DEFAULT("default", 0),
    PICKAXE("pickaxe", 7),
    AXE("axe", 6),
    SHOVEL("shovel", 8),
    HOE("hoe", 9),
    SWORD("sword", 10),
    NONE("none", 0);

    private final String id;
    private final int modelData;

    private ToolMode(String id, int modelData) {
        this.id = id;
        this.modelData = modelData;
    }

    public static ToolMode fromId(String id) {
        for (ToolMode mode : ToolMode.values()) {
            if (!mode.id.equals(id)) continue;
            return mode;
        }
        return DEFAULT;
    }

    public String getId() {
        return this.id;
    }

    public int getModelData() {
        return this.modelData;
    }

    public boolean isToolMode() {
        return this != DEFAULT && this != NONE;
    }
}

