/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.effects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public final class ParticleEffects {
    private ParticleEffects() {
    }

    public static void spawnScrapDustParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleEffects.spawnServerScrapParticles(serverLevel, pos);
        } else if (level.f_46443_) {
            ParticleEffects.spawnClientScrapParticles(level, pos);
        }
    }

    public static void spawnMetalSparkParticles(Level level, BlockPos pos) {
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.6;
                    double y = (double)pos.m_123342_() + 0.2 + level.f_46441_.m_188500_() * 0.4;
                    double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.6;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 1, (level.f_46441_.m_188500_() - 0.5) * 0.1, level.f_46441_.m_188500_() * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1, 0.02);
                }
                break block3;
            }
            if (!level.f_46443_) break block3;
            for (int i = 0; i < 8; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8;
                double y = (double)pos.m_123342_() + 0.1 + level.f_46441_.m_188500_() * 0.3;
                double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.05, level.f_46441_.m_188500_() * 0.03, (level.f_46441_.m_188500_() - 0.5) * 0.05);
            }
        }
    }

    public static void spawnTechCircuitParticles(Level level, BlockPos pos) {
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 4; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8;
                    double y = (double)pos.m_123342_() + 0.15 + level.f_46441_.m_188500_() * 0.3;
                    double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 0.8;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 1, (level.f_46441_.m_188500_() - 0.5) * 0.06, level.f_46441_.m_188500_() * 0.06, (level.f_46441_.m_188500_() - 0.5) * 0.06, 0.02);
                }
                break block3;
            }
            if (!level.f_46443_) break block3;
            for (int i = 0; i < 6; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.0;
                double y = (double)pos.m_123342_() + 0.1 + level.f_46441_.m_188500_() * 0.25;
                double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.0;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.04, level.f_46441_.m_188500_() * 0.02, (level.f_46441_.m_188500_() - 0.5) * 0.04);
            }
        }
    }

    public static void spawnGenericParticles(Level level, BlockPos pos, ParticleOptions particleType, int count, double spread) {
        block3: {
            block2: {
                if (!(level instanceof ServerLevel)) break block2;
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < count; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spread;
                    double y = (double)pos.m_123342_() + 0.1 + level.f_46441_.m_188500_() * 0.3;
                    double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spread;
                    serverLevel.m_8767_(particleType, x, y, z, 1, (level.f_46441_.m_188500_() - 0.5) * 0.08, level.f_46441_.m_188500_() * 0.08, (level.f_46441_.m_188500_() - 0.5) * 0.08, 0.02);
                }
                break block3;
            }
            if (!level.f_46443_) break block3;
            for (int i = 0; i < count; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spread;
                double y = (double)pos.m_123342_() + 0.1 + level.f_46441_.m_188500_() * 0.3;
                double z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * spread;
                level.m_7106_(particleType, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.06, level.f_46441_.m_188500_() * 0.04, (level.f_46441_.m_188500_() - 0.5) * 0.06);
            }
        }
    }

    private static void spawnServerScrapParticles(ServerLevel serverLevel, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.8;
            double y = (double)pos.m_123342_() + 0.1 + serverLevel.f_46441_.m_188500_() * 0.3;
            double z = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 0.8;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 1, (serverLevel.f_46441_.m_188500_() - 0.5) * 0.08, serverLevel.f_46441_.m_188500_() * 0.08, (serverLevel.f_46441_.m_188500_() - 0.5) * 0.08, 0.02);
        }
    }

    private static void spawnClientScrapParticles(Level level, BlockPos pos) {
        double z;
        double y;
        double x;
        int i;
        for (i = 0; i < 12; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.4;
            y = (double)pos.m_123342_() + 0.05 + level.f_46441_.m_188500_() * 0.4;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.06, level.f_46441_.m_188500_() * 0.04, (level.f_46441_.m_188500_() - 0.5) * 0.06);
        }
        for (i = 0; i < 8; ++i) {
            x = (double)pos.m_123341_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.0;
            y = (double)pos.m_123342_() + 0.1 + level.f_46441_.m_188500_() * 0.2;
            z = (double)pos.m_123343_() + 0.5 + (level.f_46441_.m_188500_() - 0.5) * 1.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.03, level.f_46441_.m_188500_() * 0.02, (level.f_46441_.m_188500_() - 0.5) * 0.03);
        }
    }
}

