/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.energy.EnergyData;
import de.markusbordihn.scraptechworkshop.energy.BatteryStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class EnergyManager {
    private EnergyManager() {
    }

    public static EnergyData getEnergyData(ItemStack itemStack, int maxEnergy) {
        return new EnergyData(itemStack, maxEnergy);
    }

    public static EnergyData getEnergyData(ItemStack itemStack) {
        return new EnergyData(itemStack);
    }

    public static BatteryStatus getBatteryStatus(ItemStack itemStack) {
        return new BatteryStatus(itemStack);
    }

    public static EnergyStatus getEnergyStatus(ItemStack itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).status();
    }

    public static boolean hasEnergy(ItemStack itemStack, int maxEnergy, int amount) {
        return EnergyManager.getEnergyData(itemStack, maxEnergy).hasEnergy(amount);
    }

    public static boolean hasEnergy(ItemStack itemStack, int amount) {
        return EnergyManager.getEnergyData(itemStack).hasEnergy(amount);
    }

    public static void setEnergy(ItemStack itemStack, int maxEnergy, int energy) {
        EnergyData energyData = new EnergyData(Math.max(1, Math.min(energy, maxEnergy)), maxEnergy, 100);
        energyData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, energyData);
    }

    public static void consumeEnergy(ItemStack itemStack, int maxEnergy, int amount) {
        BatteryStatus batteryStatus = EnergyManager.getBatteryStatus(itemStack);
        if (!batteryStatus.canDischarge()) {
            return;
        }
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        EnergyData updatedData = energyData.consume(amount);
        updatedData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, updatedData);
    }

    public static void addEnergy(ItemStack itemStack, int maxEnergy, int amount) {
        BatteryStatus batteryStatus = EnergyManager.getBatteryStatus(itemStack);
        if (!batteryStatus.canCharge()) {
            return;
        }
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        EnergyData updatedData = energyData.add(amount);
        updatedData.writeToItemStack(itemStack);
        EnergyManager.updateBatteryStatus(itemStack, updatedData);
    }

    private static void updateBatteryStatus(ItemStack itemStack, EnergyData energyData) {
        BatteryStatus currentStatus = EnergyManager.getBatteryStatus(itemStack);
        EnergyStatus newStatus = EnergyStatus.fromEnergyLevel(energyData.current(), energyData.maximum());
        if (currentStatus.status() != newStatus) {
            BatteryStatus updatedStatus = currentStatus.withStatus(newStatus);
            updatedStatus.writeToItemStack(itemStack);
        }
    }

    public static boolean canReceiveEnergy(ItemStack itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).canCharge();
    }

    public static boolean canExtractEnergy(ItemStack itemStack) {
        return EnergyManager.getBatteryStatus(itemStack).canDischarge();
    }

    public static int receiveEnergy(ItemStack itemStack, int maxEnergy, int maxReceive, boolean simulate) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        int canReceive = Math.min(maxReceive, energyData.maximum() - energyData.current());
        if (!simulate && canReceive > 0) {
            EnergyManager.addEnergy(itemStack, maxEnergy, canReceive);
        }
        return canReceive;
    }

    public static int extractEnergy(ItemStack itemStack, int maxEnergy, int maxExtract, boolean simulate) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        int canExtract = Math.min(maxExtract, energyData.current());
        if (!simulate && canExtract > 0) {
            EnergyManager.consumeEnergy(itemStack, maxEnergy, canExtract);
        }
        return canExtract;
    }

    public static int getEnergyStored(ItemStack itemStack, int maxEnergy) {
        return EnergyManager.getEnergyData(itemStack, maxEnergy).current();
    }

    public static int getEnergyStored(ItemStack itemStack) {
        return EnergyManager.getEnergyData(itemStack).current();
    }

    public static int getMaxEnergyStored(ItemStack itemStack, int maxEnergy) {
        return maxEnergy;
    }

    public static int getMaxEnergyStored(ItemStack itemStack) {
        return EnergyManager.getEnergyData(itemStack).maximum();
    }

    public static void syncFromBattery(ItemStack itemStack, int maxEnergy, ItemStack battery) {
        EnergyData currentData;
        EnergyCellItem batteryItem;
        int batteryEnergy;
        int transferAmount;
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem && (transferAmount = Math.min(batteryEnergy = (batteryItem = (EnergyCellItem)item).getEnergy(battery), maxEnergy - (currentData = EnergyManager.getEnergyData(itemStack, maxEnergy)).current())) > 0) {
            batteryItem.consumeEnergy(battery, transferAmount);
            EnergyManager.addEnergy(itemStack, maxEnergy, transferAmount);
        }
    }

    public static void consumeWithBatteryBackup(ItemStack itemStack, int maxEnergy, int amount, ItemStack battery) {
        EnergyData energyData = EnergyManager.getEnergyData(itemStack, maxEnergy);
        if (energyData.hasEnergy(amount)) {
            EnergyManager.consumeEnergy(itemStack, maxEnergy, amount);
            return;
        }
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy >= amount) {
                batteryItem.consumeEnergy(battery, amount);
                EnergyManager.syncFromBattery(itemStack, maxEnergy, battery);
                return;
            }
            if (batteryEnergy > 0) {
                batteryItem.consumeEnergy(battery, batteryEnergy);
                amount -= batteryEnergy;
                EnergyManager.syncFromBattery(itemStack, maxEnergy, battery);
            }
        }
        EnergyData updatedData = energyData.consume(Math.max(1, energyData.current() - amount));
        updatedData.writeToItemStack(itemStack);
    }
}

