/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.hololog;

import de.markusbordihn.scraptechworkshop.block.entity.hololog.HoloCubeBlockEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogStatus;
import de.markusbordihn.scraptechworkshop.item.hololog.HoloCubeItem;
import de.markusbordihn.scraptechworkshop.registry.item.hololog.HoloLogItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlock
extends BaseEntityBlock {
    public static final String ID = "holo_cube";
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HoloLogStatus> STATUS = EnumProperty.m_61587_((String)"status", HoloLogStatus.class);
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875);

    public HoloCubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STATUS, (Comparable)((Object)HoloLogStatus.READY)));
    }

    public static void updateStatus(Level level, BlockPos blockPos, HoloLogStatus newStatus) {
        BlockState currentState = level.m_8055_(blockPos);
        if (currentState.m_60734_() instanceof HoloCubeBlock && currentState.m_61143_(STATUS) != newStatus) {
            level.m_7731_(blockPos, (BlockState)currentState.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, STATUS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new HoloCubeBlockEntity(blockPos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? HoloCubeBlock.m_152132_(type, HoloCubeBlockEntity.TYPE, HoloCubeBlockEntity::tick) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        double distance;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof HoloCubeBlockEntity)) {
            log.warn("No HoloCubeBlockEntity found at {}", (Object)pos);
            return InteractionResult.FAIL;
        }
        HoloCubeBlockEntity holoCubeBlockEntity = (HoloCubeBlockEntity)blockEntity;
        ResourceLocation holoLogId = holoCubeBlockEntity.getHoloLogId();
        if (holoLogId == null) {
            player.m_5661_((Component)Component.m_237113_((String)"No holo-log data found!"), true);
            log.warn("[{}] No holo-log ID found", (Object)holoCubeBlockEntity.getCubeUUID());
            return InteractionResult.FAIL;
        }
        HoloLogStatus currentStatus = (HoloLogStatus)((Object)state.m_61143_(STATUS));
        HoloLogStatus newStatus = currentStatus.cycle();
        if (currentStatus != HoloLogStatus.PLAYING && newStatus == HoloLogStatus.PLAYING && (distance = player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5)) > 1024.0) {
            player.m_5661_((Component)Component.m_237113_((String)"You must be within 32 blocks to activate the hololog!"), true);
            log.debug("[{}] Player {} too far away ({} blocks) to activate", (Object)holoCubeBlockEntity.getCubeUUID(), (Object)player.m_7755_().getString(), (Object)Math.sqrt(distance));
            return InteractionResult.FAIL;
        }
        log.debug("[{}] Player {} changed status from {} to {}", (Object)holoCubeBlockEntity.getCubeUUID(), (Object)player.m_7755_().getString(), (Object)currentStatus, (Object)newStatus);
        level.m_7731_(pos, (BlockState)state.m_61124_(STATUS, (Comparable)((Object)newStatus)), 3);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(STATUS, (Comparable)((Object)HoloLogStatus.READY));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (level.f_46443_ && (blockEntity = level.m_7702_(blockPos)) instanceof HoloCubeBlockEntity) {
                HoloCubeBlockEntity blockEntity2 = (HoloCubeBlockEntity)blockEntity;
                blockEntity2.cleanup();
            }
            super.m_6810_(state, level, blockPos, newState, isMoving);
        }
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        HoloCubeBlockEntity blockEntity;
        ResourceLocation holoLogId;
        BlockEntity blockEntity2;
        if (!level.f_46443_ && !player.m_7500_() && (blockEntity2 = level.m_7702_(blockPos)) instanceof HoloCubeBlockEntity && (holoLogId = (blockEntity = (HoloCubeBlockEntity)blockEntity2).getHoloLogId()) != null) {
            HoloCubeItem holoCubeItem = HoloLogItemRegistry.getHoloCubeItemByHoloLog(holoLogId);
            if (holoCubeItem != null) {
                ItemStack stack = new ItemStack((ItemLike)holoCubeItem);
                HoloCubeBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)stack);
            } else {
                log.warn("[{}] No HoloCube item found for HoloLog: {}", (Object)blockEntity.getCubeUUID(), (Object)holoLogId);
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, blockPos, blockState, placer, stack);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof HoloCubeBlockEntity) {
            HoloCubeBlockEntity holoCubeBlockEntity = (HoloCubeBlockEntity)blockEntity;
            Item item = stack.m_41720_();
            if (item instanceof HoloCubeItem) {
                HoloCubeItem holoCubeItem = (HoloCubeItem)item;
                ResourceLocation holoLogId = holoCubeItem.getHoloLogId();
                holoCubeBlockEntity.setHoloLogId(holoLogId);
                log.info("[{}] Placed with holo-log: {}", (Object)holoCubeBlockEntity.getCubeUUID(), (Object)holoLogId);
                if (holoLogId.equals((Object)new ResourceLocation("scrap_tech_workshop", "holologs/intro/introduction"))) {
                    level.m_7731_(blockPos, (BlockState)blockState.m_61124_(STATUS, (Comparable)((Object)HoloLogStatus.PLAYING)), 3);
                    log.info("[{}] Auto-started introduction holocube", (Object)holoCubeBlockEntity.getCubeUUID());
                }
            } else {
                log.warn("[{}] Placed without holo-log ID", (Object)holoCubeBlockEntity.getCubeUUID());
            }
        }
    }
}

