/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.ContextType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogParticle;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class HoloLogPlayerEffects {
    private static final double PARTICLE_SPAWN_SPREAD = 0.5;
    private static final double PARTICLE_VELOCITY_HORIZONTAL = 0.02;
    private static final double PARTICLE_VELOCITY_VERTICAL = 0.05;

    private HoloLogPlayerEffects() {
    }

    public static void playEffects(HoloLogEffects effects, HoloLogPlaybackContext context, Vec3 effectPos) {
        if (!(context.getLevel() instanceof ClientLevel)) {
            return;
        }
        for (HoloLogSound sound : effects.sfx()) {
            HoloLogPlayerEffects.playSound(sound.id(), sound.volume(), sound.pitch(), context);
        }
        for (HoloLogParticle particle : effects.fx()) {
            HoloLogPlayerEffects.spawnParticles(particle, effectPos, context);
        }
    }

    public static void playSound(ResourceLocation soundId, float volume, float pitch, HoloLogPlaybackContext context) {
        SoundEvent sound = SoundEvent.m_262824_((ResourceLocation)soundId);
        if (context.contextType() == ContextType.UI) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                Vec3 playerPos = mc.f_91074_.m_20182_();
                Level level = context.getLevel();
                level.m_7785_(playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, sound, SoundSource.BLOCKS, volume, pitch, false);
            }
        } else {
            Vec3 pos = context.getEffectPosition();
            Level level = context.getLevel();
            level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, volume, pitch, false);
        }
    }

    public static void spawnParticle(ParticleOptions particle, Vec3 pos, Vec3 speed, HoloLogPlaybackContext context) {
        Level level = context.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            clientLevel.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, speed.f_82480_, speed.f_82481_);
        }
    }

    private static void spawnParticles(HoloLogParticle particle, Vec3 pos, HoloLogPlaybackContext context) {
        ParticleOptions particleType = HoloLogPlayerEffects.getParticleType(particle);
        Vec3 spawnBasePos = pos;
        if (context.contextType() == ContextType.UI) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null) {
                spawnBasePos = minecraft.f_91074_.m_20182_().m_82520_(0.0, 1.5, 0.0);
            }
        }
        for (int i = 0; i < particle.count(); ++i) {
            Vec3 spawnPos = spawnBasePos.m_82520_((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            Vec3 velocity = new Vec3((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02);
            HoloLogPlayerEffects.spawnParticle(particleType, spawnPos, velocity, context);
        }
    }

    private static ParticleOptions getParticleType(HoloLogParticle particle) {
        String particleId = particle.id().m_135815_();
        if ("dust".equals(particleId) && particle.color() != null) {
            Vector3f color = HoloLogPlayerEffects.parseColor(particle.color());
            return new DustParticleOptions(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> ParticleTypes.f_123762_;
            case "portal" -> ParticleTypes.f_123760_;
            case "crit" -> ParticleTypes.f_123797_;
            case "flash" -> ParticleTypes.f_123747_;
            default -> ParticleTypes.f_123810_;
        };
    }

    private static Vector3f parseColor(String hexColor) {
        if (hexColor == null || hexColor.isEmpty()) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            return new Vector3f((float)FastColor.ARGB32.m_13665_((int)(color | 0xFF000000)) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)(color | 0xFF000000)) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)(color | 0xFF000000)) / 255.0f);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }
}

