/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.config;

import de.markusbordihn.scraptechworkshop.config.Config;
import java.io.File;
import java.util.Properties;

public class ScrapDropConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "scrap_drop.cfg";
    public static final String CONFIG_FILE_HEADER = " Scrap Drop Configuration\n\n This configuration file allows you to define the general settings for the Scrap Drop system.\n Drop chances are in percentage (0-100). Set to 0 to disable drops for that type.\n Sound effects can be enabled/disabled and volume adjusted (0.0-1.0).\n\n";
    public static int bioScrapDropChance = 1;
    public static int ceramicScrapDropChance = 1;
    public static int copperScrapDropChance = 2;
    public static int crystalScrapDropChance = 1;
    public static int fastenerScrapDropChance = 1;
    public static int fiberScrapDropChance = 1;
    public static int glassScrapDropChance = 1;
    public static int goldScrapDropChance = 2;
    public static int ironScrapDropChance = 2;
    public static int luminousScrapDropChance = 3;
    public static int metalScrapDropChance = 1;
    public static int mineralScrapDropChance = 1;
    public static int plasticScrapDropChance = 1;
    public static int rubberScrapDropChance = 1;
    public static int techScrapDropChance = 2;
    public static int woodScrapDropChance = 1;
    public static boolean enableDropSounds = true;
    public static float dropSoundVolume = 0.3f;

    public static void registerConfig() {
        ScrapDropConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        ScrapDropConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = ScrapDropConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = ScrapDropConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        bioScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "bioScrapDropChance", bioScrapDropChance);
        ceramicScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "ceramicScrapDropChance", ceramicScrapDropChance);
        copperScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "copperScrapDropChance", copperScrapDropChance);
        crystalScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "crystalScrapDropChance", crystalScrapDropChance);
        fastenerScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "fastenerScrapDropChance", fastenerScrapDropChance);
        fiberScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "fiberScrapDropChance", fiberScrapDropChance);
        glassScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "glassScrapDropChance", glassScrapDropChance);
        goldScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "goldScrapDropChance", goldScrapDropChance);
        ironScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "ironScrapDropChance", ironScrapDropChance);
        luminousScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "luminousScrapDropChance", luminousScrapDropChance);
        metalScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "metalScrapDropChance", metalScrapDropChance);
        mineralScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "mineralScrapDropChance", mineralScrapDropChance);
        plasticScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "plasticScrapDropChance", plasticScrapDropChance);
        rubberScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "rubberScrapDropChance", rubberScrapDropChance);
        techScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "techScrapDropChance", techScrapDropChance);
        woodScrapDropChance = ScrapDropConfig.parseConfigValue(properties, "woodScrapDropChance", woodScrapDropChance);
        enableDropSounds = ScrapDropConfig.parseConfigValue(properties, "enableDropSounds", enableDropSounds);
        dropSoundVolume = ScrapDropConfig.parseConfigValue(properties, "dropSoundVolume", dropSoundVolume);
        ScrapDropConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

