/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.data.multitool.ScrapMultitoolData;
import de.markusbordihn.scraptechworkshop.energy.EnergyManager;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface EnergyCellConsumer {
    public int getMaxEnergy();

    default public ItemStack getBattery(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof EnergyCellConsumer) {
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(itemStack);
            return data.battery();
        }
        return ItemStack.f_41583_;
    }

    default public void setBattery(ItemStack consumer, ItemStack battery) {
        if (consumer.m_41720_() instanceof EnergyCellConsumer) {
            ScrapMultitoolData data = ScrapMultitoolData.fromItemStack(consumer);
            ScrapMultitoolData updatedData = data.withBattery(battery);
            updatedData.saveToItemStack(consumer);
        }
    }

    default public boolean hasBattery(ItemStack consumer) {
        ItemStack battery = this.getBattery(consumer);
        return !battery.m_41619_() && battery.m_41720_() instanceof EnergyCellItem;
    }

    default public boolean hasEnergy(ItemStack consumer, int amount) {
        ItemStack battery = this.getBattery(consumer);
        if (!this.hasBattery(consumer)) {
            return false;
        }
        return EnergyManager.hasEnergyFromBattery(consumer, this.getMaxEnergy(), battery, amount);
    }

    default public boolean consumeEnergy(ItemStack itemStack, int amount) {
        if (!this.hasBattery(itemStack)) {
            return false;
        }
        ItemStack battery = this.getBattery(itemStack);
        Item item = battery.m_41720_();
        if (!(item instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)item;
        if (batteryItem.getEnergy(battery) < amount) {
            return false;
        }
        batteryItem.consumeEnergy(battery, amount);
        this.setBattery(itemStack, battery);
        this.syncEnergyDisplay(itemStack);
        return true;
    }

    default public void syncEnergyDisplay(ItemStack itemStack) {
        if (!this.hasBattery(itemStack)) {
            EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
            return;
        }
        ItemStack battery = this.getBattery(itemStack);
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy <= 1) {
                ItemStack emptyBattery = batteryItem.createEmptyBattery();
                this.setBattery(itemStack, emptyBattery);
                EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
                return;
            }
            EnergyManager.syncEnergyWithBattery(itemStack, this.getMaxEnergy(), battery);
        } else {
            EnergyManager.setEnergy(itemStack, this.getMaxEnergy(), 0);
        }
    }

    default public float getEnergyPercentage(ItemStack itemStack) {
        if (!this.hasBattery(itemStack)) {
            return 0.0f;
        }
        ItemStack battery = this.getBattery(itemStack);
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            return (float)batteryEnergy / 5000.0f;
        }
        return 0.0f;
    }
}

