/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.pathfinding.ClientSideMovement;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class RandomCollectGoal
extends Goal {
    private static final int MIN_MOVE_INTERVAL = 100;
    private static final int MAX_MOVE_INTERVAL = 200;
    private static final int MIN_PAUSE_INTERVAL = 40;
    private static final int MAX_PAUSE_INTERVAL = 80;
    private static final int STUCK_THRESHOLD = 20;
    private static final double REACH_DISTANCE = 1.0;
    private static final double LOOK_AHEAD_DISTANCE = 3.0;
    private final CollectorStationRobotEntity robot;
    private final double speedModifier;
    private final int searchRadius;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private int stateTimer;
    private boolean isFirstTarget = true;
    private boolean isPaused = false;
    private int stuckCounter = 0;
    private int rotationDelay = 0;

    public RandomCollectGoal(CollectorStationRobotEntity robot, double speedModifier, int searchRadius) {
        this.robot = robot;
        this.speedModifier = speedModifier;
        this.searchRadius = searchRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.robot.getStatus() == CollectorStationStatus.COLLECTING && this.robot.getStationPos() != null;
    }

    public boolean m_8045_() {
        return this.robot.getStatus() == CollectorStationStatus.COLLECTING;
    }

    public void m_8056_() {
        this.isFirstTarget = true;
        this.isPaused = false;
        this.stuckCounter = 0;
        this.pickNewTarget();
    }

    public void m_8041_() {
        this.robot.m_20334_(0.0, this.robot.m_20184_().f_82480_, 0.0);
        this.robot.m_7910_(0.0f);
        this.robot.setMovingFromGoal(false);
        this.robot.setDigging(false);
    }

    public void m_8037_() {
        --this.stateTimer;
        if (this.isPaused) {
            this.robot.setMovingFromGoal(false);
            this.robot.setDigging(true);
            this.spawnDiggingParticles();
            if (this.stateTimer <= 0) {
                this.isPaused = false;
                this.robot.setDigging(false);
                this.pickNewTarget();
            }
            return;
        }
        if (this.hasReachedTarget() || this.stateTimer <= 0) {
            this.robot.setMovingFromGoal(false);
            this.startPause();
            return;
        }
        if (this.rotationDelay > 0) {
            --this.rotationDelay;
            this.robot.m_20334_(0.0, this.robot.m_20184_().f_82480_, 0.0);
            this.robot.m_7910_(0.0f);
            this.robot.setMovingFromGoal(false);
            this.robot.m_21563_().m_24946_(this.wantedX, this.wantedY, this.wantedZ);
            return;
        }
        boolean isMoving = ClientSideMovement.moveTowards((Mob)this.robot, this.wantedX, this.wantedY, this.wantedZ, this.speedModifier * 0.1);
        this.robot.setMovingFromGoal(isMoving);
        if (!isMoving && !this.hasReachedTarget()) {
            ++this.stuckCounter;
            if (this.stuckCounter >= 20) {
                this.stuckCounter = 0;
                this.pickNewTarget();
            }
        } else {
            this.stuckCounter = 0;
            if (isMoving) {
                this.updateLookDirection();
            }
        }
    }

    private void startPause() {
        this.isPaused = true;
        this.stateTimer = 40 + this.robot.m_9236_().m_213780_().m_188503_(40);
        this.robot.m_20334_(0.0, this.robot.m_20184_().f_82480_, 0.0);
        this.robot.m_7910_(0.0f);
    }

    private boolean hasReachedTarget() {
        double dz;
        double dx = this.wantedX - this.robot.m_20185_();
        return Math.sqrt(dx * dx + (dz = this.wantedZ - this.robot.m_20189_()) * dz) < 1.0;
    }

    private void pickNewTarget() {
        Vec3 targetPos = this.getRandomPosition();
        if (targetPos != null) {
            this.wantedX = targetPos.f_82479_;
            this.wantedY = targetPos.f_82480_;
            this.wantedZ = targetPos.f_82481_;
            this.rotationDelay = 10;
            this.stateTimer = 100 + this.robot.m_9236_().m_213780_().m_188503_(100);
        }
    }

    private Vec3 getRandomPosition() {
        double targetZ;
        double targetX;
        BlockPos stationPos = this.robot.getStationPos();
        if (stationPos == null) {
            return null;
        }
        if (this.isFirstTarget) {
            this.isFirstTarget = false;
            Direction facing = this.robot.getFacing();
            double initialDistance = 5.0 + this.robot.m_9236_().m_213780_().m_188500_() * 5.0;
            targetX = (double)stationPos.m_123341_() + 0.5 + (double)facing.m_122429_() * initialDistance;
            targetZ = (double)stationPos.m_123343_() + 0.5 + (double)facing.m_122431_() * initialDistance;
        } else {
            double angle = this.robot.m_9236_().m_213780_().m_188500_() * Math.PI * 2.0;
            double distance = 3.0 + this.robot.m_9236_().m_213780_().m_188500_() * ((double)this.searchRadius * 0.7);
            targetX = (double)stationPos.m_123341_() + 0.5 + Math.cos(angle) * distance;
            targetZ = (double)stationPos.m_123343_() + 0.5 + Math.sin(angle) * distance;
        }
        return ClientSideMovement.findGroundPosition(this.robot.m_9236_(), targetX, stationPos.m_123342_(), targetZ, 5);
    }

    private void updateLookDirection() {
        this.robot.m_21566_().m_6849_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        double dx = this.wantedX - this.robot.m_20185_();
        double dy = this.wantedY - this.robot.m_20186_();
        double dz = this.wantedZ - this.robot.m_20189_();
        double dist = Math.sqrt(dx * dx + dz * dz);
        if (dist > 0.1) {
            double lookX = this.robot.m_20185_() + dx / dist * 3.0;
            double lookY = this.robot.m_20188_() + Math.max(0.0, dy * 0.3);
            double lookZ = this.robot.m_20189_() + dz / dist * 3.0;
            this.robot.m_21563_().m_24946_(lookX, lookY, lookZ);
        }
    }

    private void spawnDiggingParticles() {
        if (this.robot.m_9236_().m_46467_() % 5L == 0L) {
            double offsetX = (this.robot.m_9236_().m_213780_().m_188500_() - 0.5) * 0.4;
            double offsetZ = (this.robot.m_9236_().m_213780_().m_188500_() - 0.5) * 0.4;
            this.robot.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.robot.m_20185_() + offsetX, this.robot.m_20186_() + 0.1, this.robot.m_20189_() + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

