/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.fishing;

import de.markusbordihn.scraptechworkshop.config.ScrapFishingConfig;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.loot.ScrapFishingLootTables;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapFishingHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public static void handleFishing(ServerPlayer serverPlayer, ServerLevel serverLevel) {
        ItemStack fishingRodStack = ScrapFishingHandler.getFishingRod(serverPlayer);
        if (!fishingRodStack.m_41619_()) {
            ScrapFishingHandler.handleFishing(serverPlayer, serverLevel, fishingRodStack);
        }
    }

    public static void handleFishing(ServerPlayer serverPlayer, ServerLevel serverLevel, ItemStack fishingRodItemStack) {
        ItemStack actualRodStack;
        ItemStack itemStack = actualRodStack = fishingRodItemStack.m_41619_() ? ScrapFishingHandler.getFishingRod(serverPlayer) : fishingRodItemStack;
        if (actualRodStack.m_41619_()) {
            return;
        }
        Item fishingRod = actualRodStack.m_41720_();
        log.debug("Fishing event triggered for player {} with rod {}", (Object)serverPlayer, (Object)fishingRod);
        int scrapChance = ScrapFishingHandler.getScrapChanceForRod(fishingRod);
        if (scrapChance > 0 && serverLevel.f_46441_.m_188503_(100) < scrapChance) {
            ItemStack scrapStack = ScrapFishingHandler.generateScrapItem(fishingRod, serverLevel);
            ItemEntity itemEntity = new ItemEntity((Level)serverLevel, serverPlayer.m_20185_(), serverPlayer.m_20186_() + 0.5, serverPlayer.m_20189_(), scrapStack);
            itemEntity.m_32061_();
            serverLevel.m_7967_((Entity)itemEntity);
            ScrapFishingHandler.playScrapSound(serverLevel, serverPlayer, fishingRod);
            ScrapFishingHandler.logScrapFished(serverPlayer, scrapStack.m_41720_(), fishingRod, scrapChance);
        }
    }

    private static ItemStack getFishingRod(ServerPlayer serverPlayer) {
        ItemStack mainHand = serverPlayer.m_21205_();
        if (!mainHand.m_41619_() && mainHand.m_41720_() instanceof FishingRodItem) {
            return mainHand;
        }
        ItemStack offHand = serverPlayer.m_21206_();
        if (!offHand.m_41619_() && offHand.m_41720_() instanceof FishingRodItem) {
            return offHand;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack generateScrapItem(Item rod, ServerLevel serverLevel) {
        Item scrapItem = ScrapFishingHandler.getScrapItemForRod(rod, serverLevel);
        return new ItemStack((ItemLike)scrapItem, 1);
    }

    private static void playScrapSound(ServerLevel serverLevel, ServerPlayer player, Item rod) {
        if (!ScrapFishingConfig.enableSounds) {
            return;
        }
        float volume = ScrapFishingConfig.soundVolume;
        boolean isUpgradedRod = ScrapFishingHandler.isScrapRodOrBetter(rod);
        serverLevel.m_5594_(null, player.m_20183_(), isUpgradedRod ? SoundEvents.f_11668_ : SoundEvents.f_12008_, SoundSource.PLAYERS, volume * (isUpgradedRod ? 0.5f : 0.3f), (isUpgradedRod ? 1.2f : 1.5f) + serverLevel.f_46441_.m_188501_() * (isUpgradedRod ? 0.2f : 0.3f));
    }

    private static void logScrapFished(ServerPlayer serverPlayer, Item scrapItem, Item rod, int scrapChance) {
        log.debug("Player {} fished {} with {} ({}% chance)", (Object)serverPlayer.m_7755_().getString(), (Object)new ItemStack((ItemLike)scrapItem).m_41611_().getString(), (Object)rod, (Object)scrapChance);
    }

    private static int getScrapChanceForRod(Item item) {
        if (item == ModItems.MAGNET_FISHING_ROD.get()) {
            return ScrapFishingConfig.magnetRodScrapChance;
        }
        if (item == ModItems.SCRAP_FISHING_ROD.get()) {
            return ScrapFishingConfig.scrapRodScrapChance;
        }
        if (item == Items.f_42523_) {
            return ScrapFishingConfig.vanillaRodScrapChance;
        }
        return 0;
    }

    private static boolean isScrapRodOrBetter(Item item) {
        return item == ModItems.MAGNET_FISHING_ROD.get() || item == ModItems.SCRAP_FISHING_ROD.get();
    }

    private static Item getScrapItemForRod(Item item, ServerLevel serverLevel) {
        if (item == ModItems.MAGNET_FISHING_ROD.get()) {
            return ScrapFishingLootTables.getMagnetRodLoot(serverLevel.f_46441_);
        }
        if (item == ModItems.SCRAP_FISHING_ROD.get()) {
            return ScrapFishingLootTables.getScrapRodLoot(serverLevel.f_46441_);
        }
        return ScrapFishingLootTables.getVanillaRodLoot(serverLevel.f_46441_);
    }
}

