/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.scraptechworkshop.data.loot.VanillaChestLootData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class VanillaChestLootModifier
extends LootModifier {
    public static final Codec<VanillaChestLootModifier> VANILLA_CHEST_LOOT_MODIFIER_CODEC = RecordCodecBuilder.create(inst -> VanillaChestLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, VanillaChestLootModifier::new));

    public VanillaChestLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        block8: {
            ResourceLocation lootTableId = context.getQueriedLootTableId();
            if (VanillaChestLootData.shouldModifyLootTable(lootTableId)) {
                ResourceLocation injectionTable = VanillaChestLootData.getInjectionTable(lootTableId);
                if (injectionTable != null) {
                    try {
                        ServerLevel level = context.m_78952_();
                        LootTable injectionLootTable = level.m_7654_().m_278653_().m_278676_(injectionTable);
                        if (injectionLootTable != null) {
                            LootParams.Builder paramsBuilder = new LootParams.Builder(level);
                            if (context.m_78936_(LootContextParams.f_81460_)) {
                                paramsBuilder.m_287286_(LootContextParams.f_81460_, (Object)((Vec3)context.m_165124_(LootContextParams.f_81460_)));
                            }
                            if (context.m_78936_(LootContextParams.f_81455_)) {
                                paramsBuilder.m_287286_(LootContextParams.f_81455_, (Object)((Entity)context.m_165124_(LootContextParams.f_81455_)));
                            }
                            LootParams params = paramsBuilder.m_287235_(LootContextParamSets.f_81411_);
                            ObjectArrayList additionalLoot = injectionLootTable.m_287195_(params);
                            generatedLoot.addAll((ObjectList)additionalLoot);
                            VanillaChestLootData.logSuccessfulInjection(lootTableId, injectionTable);
                            break block8;
                        }
                        VanillaChestLootData.logFailedInjection(lootTableId, injectionTable, "Injection table not found");
                    }
                    catch (Exception e) {
                        VanillaChestLootData.logFailedInjection(lootTableId, injectionTable, e.getMessage());
                    }
                } else {
                    VanillaChestLootData.logSkippedInjection(lootTableId, "No injection table configured");
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return VANILLA_CHEST_LOOT_MODIFIER_CODEC;
    }
}

