/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RecyclerOutput {
    private final Item item;
    private final int minCount;
    private final int maxCount;
    private final boolean durabilityScaling;

    public RecyclerOutput(Item item, int count) {
        this(item, count, count, false);
    }

    public RecyclerOutput(Item item, int minCount, int maxCount, boolean durabilityScaling) {
        this.item = item;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.durabilityScaling = durabilityScaling;
    }

    public ItemStack createStack() {
        int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
        return new ItemStack((ItemLike)this.item, count);
    }

    public ItemStack createStackForInput(ItemStack inputStack) {
        int baseCount;
        int n = baseCount = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
        if (this.durabilityScaling && RecyclerConfig.durabilityScaling && inputStack.m_41763_()) {
            double durabilityRatio = (double)(inputStack.m_41776_() - inputStack.m_41773_()) / (double)inputStack.m_41776_();
            double scalingFactor = 0.25 + 0.75 * durabilityRatio;
            baseCount = Math.max(1, (int)Math.floor((double)baseCount * scalingFactor));
        }
        return new ItemStack((ItemLike)this.item, baseCount);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isDurabilityScaling() {
        return this.durabilityScaling;
    }
}

