/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerByproduct;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerMatch;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerOutput;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSerializer;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record RecyclerRecipe(ResourceLocation id, RecyclerMatch match, RecyclerOutput primaryOutput, List<RecyclerByproduct> byproducts, int processTime, int weight) implements Recipe<Container>
{
    private static final int INPUT_SLOT = 0;

    public RecyclerRecipe {
        if (byproducts == null) {
            byproducts = new ArrayList<RecyclerByproduct>();
        }
    }

    public boolean m_5818_(Container container, Level level) {
        if (container.m_7983_()) {
            return false;
        }
        ItemStack inputStack = container.m_8020_(0);
        return !inputStack.m_41619_() && this.match.matches(inputStack);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.primaryOutput.createStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecyclerRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecyclerRecipeType.INSTANCE;
    }

    public boolean matchesInput(ItemStack stack) {
        return this.match.matches(stack);
    }

    public List<ItemStack> getOutputsForInput(ItemStack inputStack) {
        ArrayList<ItemStack> outputs;
        block3: {
            block4: {
                outputs = new ArrayList<ItemStack>();
                outputs.add(this.primaryOutput.createStackForInput(inputStack));
                if (!RecyclerConfig.isMultiByproductMode()) break block4;
                int addedByproducts = 0;
                for (RecyclerByproduct byproduct : this.byproducts) {
                    if (addedByproducts < RecyclerConfig.maxByproductsPerOperation) {
                        if (!byproduct.shouldProduce()) continue;
                        outputs.add(byproduct.createStack());
                        ++addedByproducts;
                        continue;
                    }
                    break block3;
                }
                break block3;
            }
            if (this.byproducts.isEmpty()) break block3;
            for (RecyclerByproduct byproduct : this.byproducts) {
                if (!byproduct.shouldProduce()) continue;
                outputs.add(byproduct.createStack());
                break;
            }
        }
        return outputs;
    }
}

