/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.hololog;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogBlockPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogManager;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogStatus;
import de.markusbordihn.scraptechworkshop.data.hololog.WorldContext;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends class_2586 {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String CUBE_UUID_TAG = "CubeUUID";
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final String LAST_STATUS_TAG = "LastStatus";
    private static final String ENDED_TICK_TAG = "EndedTick";
    private static final class_2960 DEFAULT_HOLO_LOG = new class_2960("scrap_tech_workshop", "holologs/intro/introduction");
    private static final double MAX_PLAYER_DISTANCE = 32.0;
    private static final int AUTO_RESET_TICKS = 20;
    public static class_2591<HoloCubeBlockEntity> TYPE;
    private UUID cubeUUID;
    private class_2960 holoLogId;
    private UUID playerUUID;
    private HoloLogBlockPlayer player;
    private HoloLogStatus lastKnownStatus = HoloLogStatus.READY;
    private long endedAtTick = -1L;

    public HoloCubeBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.cubeUUID = UUID.randomUUID();
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, HoloCubeBlockEntity blockEntity) {
        if (!level.field_9236) {
            return;
        }
        HoloLogStatus status = (HoloLogStatus)((Object)blockState.method_11654(HoloCubeBlock.STATUS));
        class_2960 holoLogId = blockEntity.getHoloLogId();
        if (holoLogId == null) {
            if (status != HoloLogStatus.READY) {
                log.warn("[{}] Hololog ID is null but status is {}, resetting to READY", (Object)blockEntity.cubeUUID, (Object)status);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
            }
            return;
        }
        if (status == HoloLogStatus.ENDED) {
            if (blockEntity.endedAtTick < 0L) {
                blockEntity.endedAtTick = level.method_8510();
            } else if (level.method_8510() - blockEntity.endedAtTick > 20L) {
                log.debug("[{}] Auto-resetting from ENDED to READY", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
                blockEntity.endedAtTick = -1L;
                blockEntity.stopPlayback();
            }
            return;
        }
        blockEntity.endedAtTick = -1L;
        boolean playerInRange = HoloCubeBlockEntity.hasNonSpectatorPlayerInRange(level, blockPos);
        if (status == HoloLogStatus.PLAYING) {
            log.trace("[{}] PLAYING - player exists: {}, playerInRange: {}", (Object)blockEntity.cubeUUID, (Object)(blockEntity.player != null ? 1 : 0), (Object)playerInRange);
            if (!playerInRange && blockEntity.player != null) {
                log.debug("[{}] No player in range, stopping playback", (Object)blockEntity.cubeUUID);
                HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
                blockEntity.stopPlayback();
                return;
            }
            if (blockEntity.player == null && playerInRange) {
                log.info("[{}] Starting playback for hololog: {}", (Object)blockEntity.cubeUUID, (Object)holoLogId);
                blockEntity.startPlayback(level, blockPos, holoLogId);
            }
        } else if (status == HoloLogStatus.READY && blockEntity.player != null) {
            blockEntity.stopPlayback();
        }
        if (blockEntity.player != null && blockEntity.player.isPlaying()) {
            blockEntity.player.tick();
        }
        blockEntity.lastKnownStatus = status;
    }

    private static boolean hasNonSpectatorPlayerInRange(class_1937 level, class_2338 blockPos) {
        return level.method_18456().stream().filter(player -> !player.method_7325()).anyMatch(player -> {
            boolean inRange;
            double distance = player.method_5649((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
            boolean bl = inRange = distance <= 1024.0;
            if (log.isTraceEnabled()) {
                log.trace("Player {} at distance {} blocks (max: {}): {}", (Object)player.method_5477().getString(), (Object)Math.sqrt(distance), (Object)32.0, (Object)(inRange ? "IN RANGE" : "out of range"));
            }
            return inRange;
        });
    }

    private void startPlayback(class_1937 level, class_2338 blockPos, class_2960 holoLogId) {
        log.info("[{}] startPlayback() called for hololog: {}", (Object)this.cubeUUID, (Object)holoLogId);
        if (holoLogId == null) {
            log.error("[{}] Cannot start playback: holoLogId is null", (Object)this.cubeUUID);
            return;
        }
        if (!level.field_9236) {
            log.error("[{}] startPlayback() called on server side - this should never happen!", (Object)this.cubeUUID);
            return;
        }
        Optional<HoloLogData> optionalHoloLogData = HoloLogManager.loadHoloLog(holoLogId);
        if (optionalHoloLogData.isEmpty()) {
            log.error("[{}] Failed to load hololog data for: {}", (Object)this.cubeUUID, (Object)holoLogId);
            HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.READY);
            return;
        }
        HoloLogData holoLogData = optionalHoloLogData.get();
        log.info("[{}] Hololog loaded successfully: {} (lines: {}, default delay: {}s)", (Object)this.cubeUUID, (Object)holoLogId, (Object)holoLogData.lines().size(), (Object)Float.valueOf(holoLogData.lineDelay()));
        WorldContext holoLogPlaybackContext = new WorldContext(level, blockPos);
        this.player = new HoloLogBlockPlayer(holoLogData, holoLogPlaybackContext, UUID.randomUUID(), text -> {
            class_746 clientPlayer = class_310.method_1551().field_1724;
            if (clientPlayer != null && !clientPlayer.method_7325()) {
                clientPlayer.method_7353((class_2561)class_2561.method_43470((String)("\u00a77[Hololog] \u00a7f" + text)), false);
            }
        }, () -> {
            log.info("[{}] Playback finished", (Object)this.cubeUUID);
            HoloCubeBlock.updateStatus(level, blockPos, HoloLogStatus.ENDED);
        });
        this.player.start();
        log.info("[{}] Playback started", (Object)this.cubeUUID);
    }

    private void stopPlayback() {
        if (this.player != null) {
            log.debug("[{}] Stopping playback", (Object)this.cubeUUID);
            this.player.stop();
            this.player = null;
        }
    }

    public void cleanup() {
        this.stopPlayback();
    }

    public void method_11012() {
        super.method_11012();
        this.cleanup();
    }

    public UUID getCubeUUID() {
        return this.cubeUUID;
    }

    public class_2960 getHoloLogId() {
        return this.holoLogId != null ? this.holoLogId : DEFAULT_HOLO_LOG;
    }

    public void setHoloLogId(class_2960 holoLogId) {
        log.debug("[{}] Setting holo log ID to: {}", (Object)this.cubeUUID, (Object)holoLogId);
        this.holoLogId = holoLogId;
        this.method_5431();
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        if (compoundTag.method_10545(CUBE_UUID_TAG)) {
            this.cubeUUID = compoundTag.method_25926(CUBE_UUID_TAG);
        }
        if (compoundTag.method_10545(HOLOLOG_ID_TAG)) {
            try {
                this.holoLogId = new class_2960(compoundTag.method_10558(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load hololog ID: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.holoLogId = DEFAULT_HOLO_LOG;
            }
        }
        if (compoundTag.method_10545(PLAYER_UUID_TAG)) {
            this.playerUUID = compoundTag.method_25926(PLAYER_UUID_TAG);
        }
        if (compoundTag.method_10545(LAST_STATUS_TAG)) {
            try {
                this.lastKnownStatus = HoloLogStatus.valueOf(compoundTag.method_10558(LAST_STATUS_TAG).toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                log.warn("[{}] Failed to load last status: {}", (Object)this.cubeUUID, (Object)e.getMessage());
                this.lastKnownStatus = HoloLogStatus.READY;
            }
        }
        if (compoundTag.method_10545(ENDED_TICK_TAG)) {
            this.endedAtTick = compoundTag.method_10537(ENDED_TICK_TAG);
        }
        log.debug("[{}] Loaded HoloCube data", (Object)this.cubeUUID);
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_25927(CUBE_UUID_TAG, this.cubeUUID);
        compoundTag.method_10582(LAST_STATUS_TAG, this.lastKnownStatus.name());
        compoundTag.method_10544(ENDED_TICK_TAG, this.endedAtTick);
        if (this.holoLogId != null) {
            compoundTag.method_10582(HOLOLOG_ID_TAG, this.holoLogId.toString());
        }
        if (this.playerUUID != null) {
            compoundTag.method_25927(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private void syncToClient() {
        class_1937 currentLevel = this.field_11863;
        if (currentLevel != null && !currentLevel.field_9236) {
            currentLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public HoloLogBlockPlayer getPlayer() {
        return this.player;
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }
}

