/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.ContextType;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogParticle;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogSound;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import org.joml.Vector3f;

public final class HoloLogPlayerEffects {
    private static final double PARTICLE_SPAWN_SPREAD = 0.5;
    private static final double PARTICLE_VELOCITY_HORIZONTAL = 0.02;
    private static final double PARTICLE_VELOCITY_VERTICAL = 0.05;

    private HoloLogPlayerEffects() {
    }

    public static void playEffects(HoloLogEffects effects, HoloLogPlaybackContext context, class_243 effectPos) {
        if (!(context.getLevel() instanceof class_638)) {
            return;
        }
        for (HoloLogSound sound : effects.sfx()) {
            HoloLogPlayerEffects.playSound(sound.id(), sound.volume(), sound.pitch(), context);
        }
        for (HoloLogParticle particle : effects.fx()) {
            HoloLogPlayerEffects.spawnParticles(particle, effectPos, context);
        }
    }

    public static void playSound(class_2960 soundId, float volume, float pitch, HoloLogPlaybackContext context) {
        class_3414 sound = class_3414.method_47908((class_2960)soundId);
        if (context.contextType() == ContextType.UI) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                class_243 playerPos = mc.field_1724.method_19538();
                class_1937 level = context.getLevel();
                level.method_8486(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, sound, class_3419.field_15245, volume, pitch, false);
            }
        } else {
            class_243 pos = context.getEffectPosition();
            class_1937 level = context.getLevel();
            level.method_8486(pos.field_1352, pos.field_1351, pos.field_1350, sound, class_3419.field_15245, volume, pitch, false);
        }
    }

    public static void spawnParticle(class_2394 particle, class_243 pos, class_243 speed, HoloLogPlaybackContext context) {
        class_1937 class_19372 = context.getLevel();
        if (class_19372 instanceof class_638) {
            class_638 clientLevel = (class_638)class_19372;
            clientLevel.method_8406(particle, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
        }
    }

    private static void spawnParticles(HoloLogParticle particle, class_243 pos, HoloLogPlaybackContext context) {
        class_2394 particleType = HoloLogPlayerEffects.getParticleType(particle);
        class_243 spawnBasePos = pos;
        if (context.contextType() == ContextType.UI) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1724 != null) {
                spawnBasePos = minecraft.field_1724.method_19538().method_1031(0.0, 1.5, 0.0);
            }
        }
        for (int i = 0; i < particle.count(); ++i) {
            class_243 spawnPos = spawnBasePos.method_1031((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            class_243 velocity = new class_243((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02);
            HoloLogPlayerEffects.spawnParticle(particleType, spawnPos, velocity, context);
        }
    }

    private static class_2394 getParticleType(HoloLogParticle particle) {
        String particleId = particle.id().method_12832();
        if ("dust".equals(particleId) && particle.color() != null) {
            Vector3f color = HoloLogPlayerEffects.parseColor(particle.color());
            return new class_2390(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> class_2398.field_11251;
            case "portal" -> class_2398.field_11214;
            case "crit" -> class_2398.field_11205;
            case "flash" -> class_2398.field_17909;
            default -> class_2398.field_11207;
        };
    }

    private static Vector3f parseColor(String hexColor) {
        if (hexColor == null || hexColor.isEmpty()) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            return new Vector3f((float)class_5253.class_5254.method_27765((int)(color | 0xFF000000)) / 255.0f, (float)class_5253.class_5254.method_27766((int)(color | 0xFF000000)) / 255.0f, (float)class_5253.class_5254.method_27767((int)(color | 0xFF000000)) / 255.0f);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }
}

