/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogParser;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloLogManager {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<class_2960, CachedHoloLogData> CACHE = new ConcurrentHashMap<class_2960, CachedHoloLogData>();
    private static final Set<class_2960> LOGGED_PATHS = ConcurrentHashMap.newKeySet();
    private static final long CACHE_TTL_MS = 300000L;

    private HoloLogManager() {
    }

    private static class_2960 getLocalizedId(class_2960 id) {
        try {
            class_2960 englishId;
            String[] parts = id.method_12832().split("/", 2);
            if (parts.length < 2) {
                return id;
            }
            String languageCode = class_310.method_1551().method_1526().method_4669().split("_")[0];
            class_2960 localizedId = new class_2960(id.method_12836(), parts[0] + "/" + languageCode + "/" + parts[1]);
            if (HoloLogParser.holoLogExists(localizedId)) {
                return localizedId;
            }
            if (!languageCode.equals("en") && HoloLogParser.holoLogExists(englishId = new class_2960(id.method_12836(), parts[0] + "/en/" + parts[1]))) {
                if (LOGGED_PATHS.add(id)) {
                    log.debug("Using English fallback hololog: {}", (Object)englishId);
                }
                return englishId;
            }
            if (LOGGED_PATHS.add(id)) {
                log.debug("Using original hololog path: {}", (Object)id);
            }
            return id;
        }
        catch (Exception e) {
            if (LOGGED_PATHS.add(id)) {
                log.debug("Cannot access client (server-side?), using original path: {}", (Object)id);
            }
            return id;
        }
    }

    public static Optional<HoloLogData> loadHoloLog(class_2960 holoLogId) {
        Optional<HoloLogData> holoLogData;
        if (holoLogId == null) {
            log.warn("Cannot load hololog: holoLogId is null");
            return Optional.empty();
        }
        class_2960 localizedId = HoloLogManager.getLocalizedId(holoLogId);
        CachedHoloLogData cached = CACHE.get(localizedId);
        if (cached != null && !cached.isExpired()) {
            log.trace("Cache hit for hololog: {}", (Object)localizedId);
            return Optional.of(cached.data());
        }
        if (cached != null && cached.isExpired()) {
            log.debug("Cache expired for hololog: {}, reloading...", (Object)localizedId);
            CACHE.remove(localizedId);
        }
        if ((holoLogData = HoloLogParser.getHoloLog(localizedId)).isEmpty()) {
            log.error("Hololog not found: {} (localized: {})", (Object)holoLogId, (Object)localizedId);
            return Optional.empty();
        }
        HoloLogData data = holoLogData.get();
        if (data.lines().isEmpty()) {
            log.error("Hololog has no lines: {} (localized: {})", (Object)holoLogId, (Object)localizedId);
            return Optional.empty();
        }
        CACHE.put(localizedId, new CachedHoloLogData(data, System.currentTimeMillis()));
        log.debug("Cached hololog: {} (TTL: {}ms)", (Object)localizedId, (Object)300000L);
        return Optional.of(data);
    }

    public static boolean isValidHoloLog(class_2960 holoLogId) {
        if (holoLogId == null) {
            return false;
        }
        Optional<HoloLogData> holoLogData = HoloLogManager.loadHoloLog(holoLogId);
        return holoLogData.isPresent() && !holoLogData.get().lines().isEmpty();
    }

    public static void clearCache() {
        int size = CACHE.size();
        CACHE.clear();
        LOGGED_PATHS.clear();
        log.info("Cleared hololog cache ({} entries)", (Object)size);
    }

    public static int getCacheSize() {
        return CACHE.size();
    }

    public static void removeExpiredEntries() {
        int initialSize = CACHE.size();
        CACHE.entrySet().removeIf(entry -> ((CachedHoloLogData)entry.getValue()).isExpired());
        int removed = initialSize - CACHE.size();
        if (removed > 0) {
            log.debug("Removed {} expired hololog cache entries", (Object)removed);
        }
    }

    private record CachedHoloLogData(HoloLogData data, long timestamp) {
        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 300000L;
        }
    }
}

