/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3913;

public interface EnergyPowerConsumer {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";

    public int getEnergyCapacity();

    public int getBatterySlot();

    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    default public class_1799 getBattery() {
        return this.getEnergyData().battery();
    }

    default public void setBattery(class_1799 battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public class_3913 getEnergyPowerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerConsumer.this.getCurrentEnergy();
                    case 1 -> EnergyPowerConsumer.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    EnergyPowerConsumer.this.setCurrentEnergy(value);
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    default public boolean hasEnergy(int amount) {
        return this.getCurrentEnergy() >= amount;
    }

    default public boolean consumeEnergy(int amount) {
        if (this.getCurrentEnergy() >= amount) {
            this.setCurrentEnergy(this.getCurrentEnergy() - amount);
            return true;
        }
        return false;
    }

    default public boolean chargeFromBattery(int amount) {
        class_1792 class_17922;
        class_1799 battery = this.getBattery();
        if (battery.method_7960() || !((class_17922 = battery.method_7909()) instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
        int batteryEnergy = batteryItem.getEnergy(battery);
        if (batteryEnergy <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
            this.markDirty();
            return false;
        }
        int currentEnergy = this.getCurrentEnergy();
        int capacity = this.getEnergyCapacity();
        int neededEnergy = Math.min(amount, capacity - currentEnergy);
        if (neededEnergy <= 0) {
            return false;
        }
        int energyToTransfer = Math.min(neededEnergy, batteryEnergy);
        batteryItem.consumeEnergy(battery, energyToTransfer);
        this.setCurrentEnergy(currentEnergy + energyToTransfer);
        if (batteryItem.getEnergy(battery) <= 1) {
            this.setBattery(batteryItem.createEmptyBattery());
        } else {
            this.setBattery(battery);
        }
        this.markDirty();
        return true;
    }

    default public int getEnergyPercentage() {
        int capacity = this.getEnergyCapacity();
        return capacity > 0 ? this.getCurrentEnergy() * 100 / capacity : 0;
    }

    default public boolean hasBattery() {
        class_1799 battery = this.getBattery();
        return !battery.method_7960() && battery.method_7909() instanceof EnergyCellItem;
    }

    default public boolean canAcceptExternalEnergy() {
        return this.getCurrentEnergy() < this.getEnergyCapacity();
    }

    default public int receiveEnergy(int amount, boolean simulate) {
        int capacity = this.getEnergyCapacity();
        int currentEnergy = this.getCurrentEnergy();
        int energyReceived = Math.min(amount, capacity - currentEnergy);
        if (!simulate && energyReceived > 0) {
            this.setCurrentEnergy(currentEnergy + energyReceived);
        }
        return energyReceived;
    }

    default public void loadEnergyPowerConsumer(class_2487 compoundTag) {
        int energy = compoundTag.method_10550(ENERGY_TAG);
        class_1799 battery = class_1799.field_8037;
        if (compoundTag.method_10545(BATTERY_TAG)) {
            battery = class_1799.method_7915((class_2487)compoundTag.method_10562(BATTERY_TAG));
        }
        this.setEnergyData(new EnergyPowerData(energy, battery));
    }

    default public void saveEnergyPowerConsumer(class_2487 compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.method_10569(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().method_7960()) {
            class_2487 batteryTag = new class_2487();
            data.battery().method_7953(batteryTag);
            compoundTag.method_10566(BATTERY_TAG, (class_2520)batteryTag);
        }
    }
}

