/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class RecyclerOutput {
    private final class_1792 item;
    private final int minCount;
    private final int maxCount;
    private final boolean durabilityScaling;

    public RecyclerOutput(class_1792 item, int count) {
        this(item, count, count, false);
    }

    public RecyclerOutput(class_1792 item, int minCount, int maxCount, boolean durabilityScaling) {
        this.item = item;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.durabilityScaling = durabilityScaling;
    }

    public class_1799 createStack() {
        int count = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
        return new class_1799((class_1935)this.item, count);
    }

    public class_1799 createStackForInput(class_1799 inputStack) {
        int baseCount;
        int n = baseCount = this.minCount == this.maxCount ? this.minCount : this.minCount + (int)(Math.random() * (double)(this.maxCount - this.minCount + 1));
        if (this.durabilityScaling && RecyclerConfig.durabilityScaling && inputStack.method_7963()) {
            double durabilityRatio = (double)(inputStack.method_7936() - inputStack.method_7919()) / (double)inputStack.method_7936();
            double scalingFactor = 0.25 + 0.75 * durabilityRatio;
            baseCount = Math.max(1, (int)Math.floor((double)baseCount * scalingFactor));
        }
        return new class_1799((class_1935)this.item, baseCount);
    }

    public class_1792 getItem() {
        return this.item;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isDurabilityScaling() {
        return this.durabilityScaling;
    }
}

