/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.recycler;

import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSelector;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerRecipeHandler {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");

    public static RecyclerRecipe findRecipe(class_1937 level, class_1799 inputStack) {
        if (level == null || inputStack.method_7960()) {
            return null;
        }
        RecyclerRecipe recipe = RecyclerRecipeSelector.selectBestRecipe(level, inputStack).orElse(null);
        if (recipe == null) {
            log.debug("No recycler recipe found for item: {} ({})", (Object)inputStack.method_7909(), (Object)inputStack.method_7909().method_7876());
        }
        return recipe;
    }

    public static boolean canProcessRecipe(RecyclerRecipe recipe, class_1799 inputStack, class_1799[] items) {
        if (recipe == null || inputStack.method_7960() || !recipe.matchesInput(inputStack)) {
            return false;
        }
        return RecyclerRecipeHandler.canInsertOutputs(recipe.getOutputsForInput(inputStack), items);
    }

    public static void processRecipe(RecyclerRecipe recipe, class_1799 inputStack, class_1799[] items) {
        if (recipe == null || inputStack.method_7960()) {
            return;
        }
        List<class_1799> outputs = recipe.getOutputsForInput(inputStack);
        outputs.forEach(output -> RecyclerRecipeHandler.insertOutput(output, items));
        inputStack.method_7934(1);
        log.debug("Processed item with recipe: {} -> {} outputs", (Object)inputStack.method_7909(), (Object)outputs.size());
    }

    private static boolean canInsertOutputs(List<class_1799> outputs, class_1799[] items) {
        class_1799[] simulatedItems = new class_1799[items.length];
        for (int i = 0; i < items.length; ++i) {
            simulatedItems[i] = items[i].method_7972();
        }
        for (class_1799 output : outputs) {
            if (RecyclerRecipeHandler.tryInsertOutput(simulatedItems, output, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean tryInsertOutput(class_1799[] itemArray, class_1799 output, boolean isSimulation) {
        class_1799 remaining = output.method_7972();
        for (int i = 1; i <= 9 && !remaining.method_7960(); ++i) {
            class_1799 slotStack = itemArray[i];
            if (slotStack.method_7960()) {
                itemArray[i] = remaining.method_7972();
                remaining = class_1799.field_8037;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)remaining)) continue;
            int canAdd = slotStack.method_7914() - slotStack.method_7947();
            int toAdd = Math.min(canAdd, remaining.method_7947());
            slotStack.method_7933(toAdd);
            remaining.method_7934(toAdd);
        }
        return remaining.method_7960();
    }

    private static void insertOutput(class_1799 output, class_1799[] items) {
        RecyclerRecipeHandler.tryInsertOutput(items, output, false);
    }
}

