/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.collectorstation.CollectorStationBlock;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.client.entity.ClientCollectorStationRobotManager;
import de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation.RobotStatusHandler;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.data.robot.RobotRenderInfo;
import de.markusbordihn.scraptechworkshop.entity.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.collectorstationrobot.CollectorStationRobotStaticEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.CollectorStationRobotEntityRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;

public class CollectorStationBlockEntityRenderer
implements class_827<CollectorStationBlockEntity> {
    private static final float ROBOT_SCALE = 0.75f;
    private CollectorStationRobotStaticEntity cachedRobotEntity;

    public CollectorStationBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(CollectorStationBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay) {
        CollectorStationRobotEntity robot;
        class_1937 level = blockEntity.method_10997();
        if (level == null || !(level instanceof class_638)) {
            return;
        }
        class_638 clientLevel = (class_638)level;
        CollectorStationStatus status = blockEntity.getStatus();
        class_2338 blockPos = blockEntity.method_11016();
        class_2680 blockState = blockEntity.method_11010();
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)CollectorStationBlock.FACING);
        ClientCollectorStationRobotManager.updateRobot(clientLevel, blockPos, facing, status);
        if (status.isRobotActive() && (robot = ClientCollectorStationRobotManager.getRobot(blockPos)) != null && !robot.method_31481()) {
            return;
        }
        float animationTime = ((float)level.method_8510() + partialTick) * 0.05f;
        float stationCenterX = 0.5f;
        float stationCenterZ = 0.5f;
        RobotStatusHandler handler = RobotStatusHandler.getHandler(status);
        if (handler == null) {
            return;
        }
        RobotRenderInfo renderInfo = handler.calculateRenderInfo(blockEntity, level, blockPos, facing, stationCenterX, stationCenterZ, animationTime, partialTick);
        if (renderInfo == null) {
            return;
        }
        handler.spawnParticles(level, blockPos, renderInfo, partialTick);
        poseStack.method_22903();
        poseStack.method_46416(renderInfo.offsetX(), renderInfo.offsetY(), renderInfo.offsetZ());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(renderInfo.yaw()));
        if (renderInfo.pitch() != 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(renderInfo.pitch()));
        }
        poseStack.method_22905(0.75f, 0.75f, 0.75f);
        CollectorStationRobotStaticEntity robotEntity = this.getOrCreateRobotEntity(level);
        if (robotEntity != null) {
            robotEntity.field_6012 = (int)level.method_8510();
            robotEntity.setStatus(status);
            double worldX = (float)blockPos.method_10263() + renderInfo.offsetX();
            double worldY = (float)blockPos.method_10264() + renderInfo.offsetY();
            double worldZ = (float)blockPos.method_10260() + renderInfo.offsetZ();
            robotEntity.method_5814(worldX, worldY, worldZ);
            class_310 minecraft = class_310.method_1551();
            class_898 dispatcher = minecraft.method_1561();
            class_897 renderer = dispatcher.method_3953((class_1297)robotEntity);
            renderer.method_3936((class_1297)robotEntity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        }
        poseStack.method_22909();
    }

    private CollectorStationRobotStaticEntity getOrCreateRobotEntity(class_1937 level) {
        if (this.cachedRobotEntity == null && level instanceof class_638) {
            class_638 clientLevel = (class_638)level;
            this.cachedRobotEntity = new CollectorStationRobotStaticEntity((class_1299<? extends BaseRobotEntity>)CollectorStationRobotEntityRegistry.COLLECTOR_STATION_ROBOT_STATIC_ENTITY_TYPE, (class_1937)clientLevel);
            this.cachedRobotEntity.method_5814(0.0, 0.0, 0.0);
        }
        return this.cachedRobotEntity;
    }

    public int method_33893() {
        return 48;
    }
}

