/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlaybackBase;
import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlayerEffects;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogData;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogDisplayEntity;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogLine;
import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import de.markusbordihn.scraptechworkshop.entity.hololog.HoloLogHumanoidEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.HoloLogEntityRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_898;

public class HoloLogBlockPlayer
extends HoloLogPlaybackBase {
    private static final int CHECKS_PER_SECOND = 10;
    private static final float CHECK_INTERVAL = 0.1f;
    private final Consumer<String> textDisplay;
    private final Map<class_2960, class_1297> entityCache = new HashMap<class_2960, class_1297>();
    private final float ticksPerCheck;
    private float elapsedTime = 0.0f;
    private float endDelayTimer = 0.0f;
    private boolean waitingForEndDelay = false;
    private int ticksSinceLastCheck = 0;

    public HoloLogBlockPlayer(HoloLogData holoLogData, HoloLogPlaybackContext context, UUID playerId, Consumer<String> textDisplay, Runnable onComplete) {
        super(holoLogData, context, playerId, onComplete);
        this.textDisplay = textDisplay;
        this.ticksPerCheck = 2.0f;
    }

    @Override
    protected void onPlaybackStart() {
        this.elapsedTime = 0.0f;
        this.endDelayTimer = 0.0f;
        this.waitingForEndDelay = false;
        this.ticksSinceLastCheck = 0;
        if (this.textDisplay != null) {
            Object titleText = class_2561.method_43470((String)this.holoLogData.title()).getString();
            if (!this.holoLogData.subtitle().isEmpty()) {
                titleText = (String)titleText + " - " + this.holoLogData.subtitle();
            }
            this.textDisplay.accept((String)titleText);
            log.debug("Displayed title: {}", titleText);
        }
    }

    @Override
    protected void onPlaybackStop() {
    }

    @Override
    protected int getDisplayLineIndex() {
        HoloLogLine line;
        int lineIndex = -1;
        int i = 0;
        while (i < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(i)).startTime()) {
            lineIndex = i++;
        }
        return lineIndex;
    }

    @Override
    public void tick() {
        if (this.state != HoloLogPlaybackBase.PlaybackState.PLAYING) {
            return;
        }
        class_1937 level = this.context.getLevel();
        if (level == null || !(level instanceof class_638)) {
            log.warn("Level is null or not ClientLevel, stopping playback");
            this.state = HoloLogPlaybackBase.PlaybackState.STOPPED;
            return;
        }
        ++this.ticksSinceLastCheck;
        if ((float)this.ticksSinceLastCheck >= this.ticksPerCheck) {
            HoloLogLine line;
            this.elapsedTime += 0.1f;
            this.ticksSinceLastCheck = 0;
            this.startVoiceOver(this.elapsedTime);
            if (this.currentLineIndex < this.holoLogData.lines().size() && this.elapsedTime >= (line = this.holoLogData.lines().get(this.currentLineIndex)).startTime()) {
                float effectiveDelay = line.lineDelay() > 0.0f ? line.lineDelay() : this.holoLogData.lineDelay();
                log.debug("Displaying line {}/{}: '{}' at {}s (start time: {}s, delay: {}s)", (Object)(this.currentLineIndex + 1), (Object)this.holoLogData.lines().size(), (Object)(line.text().isEmpty() ? "<pause>" : line.text()), (Object)Float.valueOf(this.elapsedTime), (Object)Float.valueOf(line.startTime()), (Object)Float.valueOf(effectiveDelay));
                if (this.textDisplay != null && !line.text().isEmpty()) {
                    this.textDisplay.accept(line.text());
                }
                HoloLogPlayerEffects.playEffects(line.effects(), this.context, this.context.getEffectPosition());
                ++this.currentLineIndex;
            }
            if (this.currentLineIndex >= this.holoLogData.lines().size() && !this.waitingForEndDelay) {
                this.waitingForEndDelay = true;
                this.endDelayTimer = 0.0f;
                log.debug("All lines finished, waiting {}s before end effects", (Object)Float.valueOf(this.holoLogData.endDelay()));
            }
            if (this.waitingForEndDelay) {
                this.endDelayTimer += 0.1f;
                if (this.endDelayTimer >= this.holoLogData.endDelay()) {
                    this.completePlayback();
                }
            }
        }
    }

    @Override
    protected void renderEntity(class_4587 poseStack, class_2960 entityId, float partialTick, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderEntity(poseStack, (class_4597)mc.method_22940().method_23000(), entityId, partialTick, lightLevel);
    }

    @Override
    protected void renderEntity(class_4587 poseStack, class_4597 buffer, class_2960 entityId, float partialTick, int lightLevel) {
        class_1937 level = this.context.getLevel();
        class_1297 entity = this.getOrCreateEntity(level, entityId);
        if (entity == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_898 dispatcher = mc.method_1561();
        class_897 renderer = dispatcher.method_3953(entity);
        if (level != null) {
            entity.field_6012 = (int)level.method_8510();
        }
        renderer.method_3936(entity, 0.0f, 0.0f, poseStack, buffer, lightLevel);
    }

    @Override
    protected void renderHoloEntity(class_4587 poseStack, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderHoloEntity(poseStack, (class_4597)mc.method_22940().method_23000(), displayEntity, partialTick, lightLevel);
    }

    @Override
    protected void renderHoloEntity(class_4587 poseStack, class_4597 buffer, HoloLogDisplayEntity displayEntity, float partialTick, int lightLevel) {
        class_1937 level = this.context.getLevel();
        HoloLogHumanoidEntity holoEntity = this.getOrCreateHoloEntity(level, displayEntity);
        if (holoEntity == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_898 dispatcher = minecraft.method_1561();
        class_897 renderer = dispatcher.method_3953((class_1297)holoEntity);
        if (level != null) {
            holoEntity.field_6012 = (int)level.method_8510();
        }
        renderer.method_3936((class_1297)holoEntity, 0.0f, 0.0f, poseStack, buffer, lightLevel);
    }

    @Override
    protected void renderBlock(class_4587 poseStack, class_2960 blockId, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderBlock(poseStack, (class_4597)mc.method_22940().method_23000(), blockId, lightLevel);
    }

    @Override
    protected void renderBlock(class_4587 poseStack, class_4597 buffer, class_2960 blockId, int lightLevel) {
        class_310.method_1551().method_1541().method_3353(((class_2248)class_7923.field_41175.method_10223(blockId)).method_9564(), poseStack, buffer, lightLevel, class_4608.field_21444);
    }

    @Override
    protected void renderItem(class_4587 poseStack, class_2960 itemId, int lightLevel) {
        class_310 mc = class_310.method_1551();
        this.renderItem(poseStack, (class_4597)mc.method_22940().method_23000(), itemId, lightLevel);
    }

    @Override
    protected void renderItem(class_4587 poseStack, class_4597 buffer, class_2960 itemId, int lightLevel) {
        class_310.method_1551().method_1480().method_23178(new class_1799((class_1935)class_7923.field_41178.method_10223(itemId)), class_811.field_4318, lightLevel, class_4608.field_21444, poseStack, buffer, this.context.getLevel(), 0);
    }

    private class_1297 getOrCreateEntity(class_1937 level, class_2960 entityId) {
        class_1297 cached;
        if (level == null) {
            return null;
        }
        if (this.entityCache.containsKey(entityId) && (cached = this.entityCache.get(entityId)) != null && !cached.method_31481()) {
            return cached;
        }
        Optional entityType = class_7923.field_41177.method_17966(entityId);
        if (entityType.isEmpty()) {
            log.warn("Entity type not found: {}", (Object)entityId);
            return null;
        }
        class_1297 entity = ((class_1299)entityType.get()).method_5883(level);
        if (entity != null) {
            entity.method_5648(false);
            this.entityCache.put(entityId, entity);
        }
        return entity;
    }

    private HoloLogHumanoidEntity getOrCreateHoloEntity(class_1937 level, HoloLogDisplayEntity displayEntity) {
        HoloLogHumanoidEntity holoEntity;
        class_1297 cached;
        if (level == null || HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE == null) {
            return null;
        }
        class_2960 cacheKey = displayEntity.texture();
        if (cacheKey == null) {
            cacheKey = new class_2960("scrap_tech_workshop", "hololog_humanoid_default");
        }
        if (this.entityCache.containsKey(cacheKey) && (cached = this.entityCache.get(cacheKey)) instanceof HoloLogHumanoidEntity) {
            HoloLogHumanoidEntity holoEntity2 = (HoloLogHumanoidEntity)cached;
            if (!cached.method_31481()) {
                return holoEntity2;
            }
        }
        if ((holoEntity = (HoloLogHumanoidEntity)HoloLogEntityRegistry.HOLO_LOG_HUMANOID_ENTITY_TYPE.method_5883(level)) != null) {
            holoEntity.method_5648(false);
            if (displayEntity.texture() != null) {
                holoEntity.setTexture(displayEntity.texture());
            }
            holoEntity.setSlim(displayEntity.slim());
            this.entityCache.put(cacheKey, (class_1297)holoEntity);
        }
        return holoEntity;
    }
}

