/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HoloLogPlaybackContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HoloLogPlayerAudio {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, class_1113> ACTIVE_VOICE_OVERS = new HashMap<UUID, class_1113>();

    private HoloLogPlayerAudio() {
    }

    public static void playVoiceOver(UUID playerId, class_2960 voiceOverId, HoloLogPlaybackContext context) {
        if (voiceOverId == null) {
            log.debug("No voice-over specified for player {}", (Object)playerId);
            return;
        }
        HoloLogPlayerAudio.stopVoiceOver(playerId);
        try {
            class_310 minecraft = class_310.method_1551();
            String soundEventPath = voiceOverId.method_12832().replace('/', '.');
            class_2960 soundEventId = new class_2960(voiceOverId.method_12836(), soundEventPath);
            if (!minecraft.method_1483().method_4864().contains(soundEventId)) {
                log.error("Voice-over sound '{}' is not registered in sounds.json! Make sure to add an entry for '{}' with the sound file at 'sounds/{}.ogg'", (Object)soundEventId, (Object)soundEventId, (Object)voiceOverId.method_12832());
                return;
            }
            class_3414 soundEvent = class_3414.method_47908((class_2960)soundEventId);
            class_1109 soundInstance = new class_1109(soundEvent.method_14833(), class_3419.field_15246, 1.0f, 1.0f, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
            minecraft.method_1483().method_4873((class_1113)soundInstance);
            ACTIVE_VOICE_OVERS.put(playerId, (class_1113)soundInstance);
            log.info("Started voice-over playback: {} (sound event: {}) for player {}", (Object)voiceOverId, (Object)soundEventId, (Object)playerId);
        }
        catch (Exception e) {
            log.error("Failed to play voice-over {}: {}", (Object)voiceOverId, (Object)e.getMessage(), (Object)e);
        }
    }

    public static void stopVoiceOver(UUID playerId) {
        class_1113 soundInstance = ACTIVE_VOICE_OVERS.remove(playerId);
        if (soundInstance != null) {
            try {
                class_310.method_1551().method_1483().method_4870(soundInstance);
                log.debug("Stopped voice-over for player {}", (Object)playerId);
            }
            catch (Exception e) {
                log.warn("Failed to stop voice-over for player {}: {}", (Object)playerId, (Object)e.getMessage());
            }
        }
    }

    public static void stopAll() {
        for (UUID playerId : ACTIVE_VOICE_OVERS.keySet()) {
            HoloLogPlayerAudio.stopVoiceOver(playerId);
        }
        ACTIVE_VOICE_OVERS.clear();
        log.debug("Stopped all voice-overs");
    }
}

