/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.multitool;

public enum ToolMode {
    DEFAULT("default", 0, "mode.default", 0xAAAAAA),
    PICKAXE("pickaxe", 7, "mode.pickaxe", 0x888888),
    AXE("axe", 6, "mode.axe", 0xFF8800),
    SHOVEL("shovel", 8, "mode.shovel", 0xBB8844),
    HOE("hoe", 9, "mode.hoe", 43520),
    SWORD("sword", 10, "mode.sword", 0xFF0000),
    NONE("none", 0, "mode.none", 0xAAAAAA);

    private final String id;
    private final int modelData;
    private final String translationKey;
    private final int color;

    private ToolMode(String id, int modelData, String translationKey, int color) {
        this.id = id;
        this.modelData = modelData;
        this.translationKey = "item.scrap_tech_workshop.scrap_multitool." + translationKey;
        this.color = color;
    }

    public static ToolMode fromId(String id) {
        for (ToolMode mode : ToolMode.values()) {
            if (!mode.id.equals(id)) continue;
            return mode;
        }
        return DEFAULT;
    }

    public String getId() {
        return this.id;
    }

    public int getModelData() {
        return this.modelData;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isToolMode() {
        return this != DEFAULT && this != NONE;
    }
}

