/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.data.scrap;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public enum ScrapSoundType {
    STONE(class_3417.field_15026),
    METAL(class_3417.field_26960),
    CRYSTAL(class_3417.field_26942),
    CHAIN(class_3417.field_24065),
    ANVIL(class_3417.field_14833),
    IRON(class_3417.field_15131),
    GLASS(class_3417.field_15081),
    SOFT(class_3417.field_14983),
    ELECTRONIC(class_3417.field_19199),
    WOOD(class_3417.field_15215),
    SLIME(class_3417.field_15194);

    private static final Map<ScrapType, ScrapSoundType> SCRAP_TYPE_TO_SOUND_MAP;
    private final class_3414 soundEvent;

    private ScrapSoundType(class_3414 soundEvent) {
        this.soundEvent = soundEvent;
    }

    public static ScrapSoundType forScrapType(ScrapType scrapType) {
        return SCRAP_TYPE_TO_SOUND_MAP.get((Object)scrapType);
    }

    public class_3414 getSoundEvent() {
        return this.soundEvent;
    }

    static {
        HashMap<ScrapType, ScrapSoundType> map = new HashMap<ScrapType, ScrapSoundType>();
        map.put(ScrapType.BIO, SOFT);
        map.put(ScrapType.CERAMIC, STONE);
        map.put(ScrapType.COPPER, METAL);
        map.put(ScrapType.CRYSTAL, CRYSTAL);
        map.put(ScrapType.FASTENER, CHAIN);
        map.put(ScrapType.FIBER, SOFT);
        map.put(ScrapType.GLASS, GLASS);
        map.put(ScrapType.GOLD, ANVIL);
        map.put(ScrapType.IRON, IRON);
        map.put(ScrapType.LUMINOUS, GLASS);
        map.put(ScrapType.METAL, METAL);
        map.put(ScrapType.MINERAL, STONE);
        map.put(ScrapType.PLASTIC, SOFT);
        map.put(ScrapType.RUBBER, SLIME);
        map.put(ScrapType.TECH, ELECTRONIC);
        map.put(ScrapType.WOOD, WOOD);
        SCRAP_TYPE_TO_SOUND_MAP = Map.copyOf(map);
    }
}

