/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.collectorstation;

import de.markusbordihn.scraptechworkshop.block.collectorstation.CollectorStationBlock;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationContainer;
import de.markusbordihn.scraptechworkshop.config.CollectorStationConfig;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.upgrade.ChargeUpgradeItem;
import de.markusbordihn.scraptechworkshop.item.upgrade.SpeedUpgradeItem;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootGenerator;
import de.markusbordihn.scraptechworkshop.menu.CollectorStationMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollectorStationBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    public static final int BATTERY_SLOT = 0;
    public static final int FIRST_STORAGE_SLOT = 1;
    public static final int LAST_STORAGE_SLOT = 24;
    public static final int STORAGE_SLOTS = 24;
    public static final int FIRST_UPGRADE_SLOT = 25;
    public static final int LAST_UPGRADE_SLOT = 28;
    public static final int UPGRADE_SLOTS = 4;
    public static final int TOTAL_SLOTS = 29;
    private static final Logger log = LogManager.getLogger();
    private static final int ENERGY_CONSUMPTION_INTERVAL = 20;
    private static final int ITEM_ADDITION_INTERVAL = 10;
    private static final int ENERGY_CONSUMPTION_AMOUNT = 5;
    private static final int MAX_ENERGY = 5000;
    private static final float SOUND_VOLUME = 0.5f;
    private static final float SOUND_PITCH = 1.0f;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.collector_station";
    private static final String ITEM_TAG_PREFIX = "Item";
    private static final String STATE_TIMER_TAG = "StateTimer";
    private static final String ENERGY_TAG = "Energy";
    private static final String BIOME_TAG = "Biome";
    private static final int DATA_STATUS = 0;
    private static final int DATA_STATE_TIMER = 1;
    private static final int DATA_ENERGY = 2;
    private static final int DATA_POWERED = 3;
    private static final int DATA_COUNT = 4;
    public static BlockEntityType<CollectorStationBlockEntity> TYPE;
    private final CollectorStationContainer container;
    private int stateTimer = 0;
    private int currentEnergy = 0;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CollectorStationBlockEntity.this.getStatus().ordinal();
                case 1 -> CollectorStationBlockEntity.this.stateTimer;
                case 2 -> CollectorStationBlockEntity.this.currentEnergy;
                case 3 -> {
                    if (CollectorStationBlockEntity.this.getStatus().isPowered()) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CollectorStationBlockEntity.this.setStatus(CollectorStationStatus.values()[value]);
                    break;
                }
                case 1: {
                    CollectorStationBlockEntity.this.stateTimer = value;
                    break;
                }
                case 2: {
                    CollectorStationBlockEntity.this.currentEnergy = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private String cachedBiome = "";
    private List<ItemStack> pendingItems = new ArrayList<ItemStack>();
    private int processingIndex = 0;

    public CollectorStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new CollectorStationContainer(this);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, CollectorStationBlockEntity blockEntity) {
        if (level.f_46443_) {
            blockEntity.clientTick(level, blockPos, blockState);
        } else {
            blockEntity.serverTick(level, blockPos, blockState);
        }
    }

    private void clientTick(Level level, BlockPos blockPos, BlockState blockState) {
    }

    private void serverTick(Level level, BlockPos blockPos, BlockState blockState) {
        CollectorStationStatus currentStatus = this.getStatus();
        if (currentStatus == CollectorStationStatus.NO_POWER || currentStatus == CollectorStationStatus.CHARGING) {
            Item item;
            ItemStack battery = this.getBattery();
            if (battery.m_41619_() || !((item = battery.m_41720_()) instanceof EnergyCellItem)) {
                if (currentStatus != CollectorStationStatus.NO_POWER) {
                    this.setStatus(CollectorStationStatus.NO_POWER);
                    this.stateTimer = 0;
                }
                return;
            }
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            this.currentEnergy = batteryItem.getEnergy(battery);
            if (this.currentEnergy < CollectorStationConfig.energyPerCycle) {
                if (currentStatus != CollectorStationStatus.NO_POWER) {
                    this.setStatus(CollectorStationStatus.NO_POWER);
                    this.stateTimer = 0;
                }
                return;
            }
        }
        if (level.m_46467_() % (long)CollectorStationConfig.checkInterval != 0L) {
            return;
        }
        switch (this.getStatus()) {
            case NO_POWER: {
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: NO_POWER -> CHARGING", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11739_, 0.3f, 1.2f);
                break;
            }
            case CHARGING: {
                Item item;
                ItemStack battery;
                int chargeMultiplier = this.getChargeMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * chargeMultiplier;
                if (this.stateTimer == CollectorStationConfig.checkInterval * chargeMultiplier) {
                    this.playSound(level, blockPos, SoundEvents.f_11737_, 0.5f, 1.5f);
                }
                if (this.stateTimer % 20 == 0 && this.currentEnergy > 0 && !(battery = this.getBattery()).m_41619_() && (item = battery.m_41720_()) instanceof EnergyCellItem) {
                    EnergyCellItem batteryItem = (EnergyCellItem)item;
                    int energyToConsume = Math.min(5, this.currentEnergy);
                    batteryItem.consumeEnergy(battery, energyToConsume);
                    this.currentEnergy = batteryItem.getEnergy(battery);
                    if (this.currentEnergy <= 1) {
                        this.setBattery(batteryItem.createEmptyBattery());
                        log.debug("[CollectorStation@{}] Battery drained, replaced with empty battery", (Object)blockPos);
                    }
                }
                if (this.stateTimer < CollectorStationConfig.chargingTime) break;
                if (this.hasSpaceInStorage()) {
                    this.setStatus(CollectorStationStatus.COLLECTING);
                    this.stateTimer = 0;
                    this.cachedBiome = ((ResourceKey)level.m_204166_(blockPos).m_203543_().get()).m_135782_().toString();
                    log.debug("[CollectorStation@{}] Status changed: CHARGING -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                    this.playSound(level, blockPos, SoundEvents.f_12312_, 0.5f, 0.8f);
                    break;
                }
                this.setStatus(CollectorStationStatus.NO_STORAGE);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: CHARGING -> NO_STORAGE (storage full)", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_12055_, 0.5f, 0.7f);
                break;
            }
            case NO_STORAGE: {
                if (!this.hasSpaceInStorage()) break;
                this.setStatus(CollectorStationStatus.COLLECTING);
                this.stateTimer = 0;
                this.cachedBiome = ((ResourceKey)level.m_204166_(blockPos).m_203543_().get()).m_135782_().toString();
                log.debug("[CollectorStation@{}] Status changed: NO_STORAGE -> COLLECTING (Biome: {})", (Object)blockPos, (Object)this.cachedBiome);
                this.playSound(level, blockPos, SoundEvents.f_12312_, 0.5f, 0.8f);
                break;
            }
            case COLLECTING: {
                int speedMultiplier = this.getSpeedMultiplierBonus();
                this.stateTimer += CollectorStationConfig.checkInterval * speedMultiplier;
                if (this.stateTimer < CollectorStationConfig.collectingTime) break;
                this.setStatus(CollectorStationStatus.RETURNING);
                this.stateTimer = 0;
                log.debug("[CollectorStation@{}] Status changed: COLLECTING -> RETURNING (collected for {} ticks)", (Object)blockPos, (Object)CollectorStationConfig.collectingTime);
                this.playSound(level, blockPos, SoundEvents.f_12311_, 0.5f, 0.9f);
                break;
            }
            case RETURNING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer < CollectorStationConfig.returningTime) break;
                this.setStatus(CollectorStationStatus.PROCESSING);
                this.stateTimer = 0;
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: RETURNING -> PROCESSING", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11668_, 0.3f, 1.5f);
                this.pendingItems = ScrapLootGenerator.generateScrapForBiome(level, blockPos, this.cachedBiome);
                log.debug("[CollectorStation@{}] Generated {} scrap items to process", (Object)blockPos, (Object)this.pendingItems.size());
                break;
            }
            case PROCESSING: {
                this.stateTimer += CollectorStationConfig.checkInterval;
                if (this.stateTimer % 10 == 0 && this.processingIndex < this.pendingItems.size()) {
                    ItemStack scrap = this.pendingItems.get(this.processingIndex);
                    if (!scrap.m_41619_()) {
                        this.addSingleScrapItem(scrap, blockPos);
                        this.playSound(level, blockPos, SoundEvents.f_12019_, 0.3f, 1.2f);
                    }
                    ++this.processingIndex;
                }
                if (this.stateTimer < CollectorStationConfig.processingTime || this.processingIndex < this.pendingItems.size()) break;
                this.setStatus(CollectorStationStatus.CHARGING);
                this.stateTimer = 0;
                this.pendingItems.clear();
                this.processingIndex = 0;
                log.debug("[CollectorStation@{}] Status changed: PROCESSING -> CHARGING (cycle complete)", (Object)blockPos);
                this.playSound(level, blockPos, SoundEvents.f_11738_, 0.4f, 1.0f);
            }
        }
        this.m_6596_();
    }

    private boolean hasSpaceInStorage() {
        for (int i = 1; i <= 24; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private int getSpeedMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            Item item;
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof SpeedUpgradeItem)) continue;
            SpeedUpgradeItem speedUpgrade = (SpeedUpgradeItem)item;
            totalMultiplier += speedUpgrade.getSpeedMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private int getChargeMultiplierBonus() {
        int totalMultiplier = 1;
        for (int i = 25; i <= 28; ++i) {
            Item item;
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ChargeUpgradeItem)) continue;
            ChargeUpgradeItem chargeUpgrade = (ChargeUpgradeItem)item;
            totalMultiplier += chargeUpgrade.getChargeMultiplier() - 1;
        }
        return totalMultiplier;
    }

    private void addSingleScrapItem(ItemStack scrap, BlockPos blockPos) {
        if (scrap.m_41619_()) {
            return;
        }
        for (int i = 1; i <= 24; ++i) {
            ItemStack slotStack = this.container.m_8020_(i);
            if (slotStack.m_41619_()) {
                this.container.m_6836_(i, scrap.m_41777_());
                log.debug("[CollectorStation@{}] Added {} x{} to slot {}", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_(), (Object)i);
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)scrap) || slotStack.m_41613_() + scrap.m_41613_() > slotStack.m_41741_()) continue;
            slotStack.m_41769_(scrap.m_41613_());
            log.debug("[CollectorStation@{}] Stacked {} x{} into slot {} (total: {})", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_(), (Object)i, (Object)slotStack.m_41613_());
            return;
        }
        log.warn("[CollectorStation@{}] No space for {} x{}", (Object)blockPos, (Object)scrap.m_41720_(), (Object)scrap.m_41613_());
    }

    private void playSound(Level level, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        if (level != null && !level.f_46443_) {
            level.m_5594_(null, blockPos, sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public ItemStack getBattery() {
        return this.container.m_8020_(0);
    }

    public void setBattery(ItemStack battery) {
        this.container.m_6836_(0, battery);
    }

    public CollectorStationContainer getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    public CollectorStationStatus getStatus() {
        if (this.f_58857_ != null && this.m_58900_().m_61138_(CollectorStationBlock.STATE)) {
            return (CollectorStationStatus)((Object)this.m_58900_().m_61143_(CollectorStationBlock.STATE));
        }
        return CollectorStationStatus.NO_POWER;
    }

    private void setStatus(CollectorStationStatus newStatus) {
        BlockState currentState;
        if (this.f_58857_ != null && this.m_58900_().m_61138_(CollectorStationBlock.STATE) && (currentState = this.m_58900_()).m_61143_(CollectorStationBlock.STATE) != newStatus) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_(CollectorStationBlock.STATE, (Comparable)((Object)newStatus)), 3);
        }
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        for (int i = 0; i < 29; ++i) {
            if (compoundTag.m_128441_(ITEM_TAG_PREFIX + i)) {
                this.container.getItems().set(i, (Object)ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_(ITEM_TAG_PREFIX + i)));
                continue;
            }
            this.container.getItems().set(i, (Object)ItemStack.f_41583_);
        }
        this.stateTimer = compoundTag.m_128451_(STATE_TIMER_TAG);
        this.currentEnergy = compoundTag.m_128451_(ENERGY_TAG);
        this.cachedBiome = compoundTag.m_128461_(BIOME_TAG);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        for (int i = 0; i < 29; ++i) {
            if (((ItemStack)this.container.getItems().get(i)).m_41619_()) continue;
            compoundTag.m_128365_(ITEM_TAG_PREFIX + i, (Tag)((ItemStack)this.container.getItems().get(i)).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128405_(STATE_TIMER_TAG, this.stateTimer);
        compoundTag.m_128405_(ENERGY_TAG, this.currentEnergy);
        compoundTag.m_128359_(BIOME_TAG, this.cachedBiome);
    }

    public int m_6643_() {
        return this.container.m_6643_();
    }

    public boolean m_7983_() {
        return this.container.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.container.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.container.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.container.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        this.container.m_6836_(slot, itemStack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.container.m_6542_(player);
    }

    public void m_6211_() {
        this.container.m_6211_();
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        return this.container.m_7013_(slot, itemStack);
    }

    public int[] m_7071_(Direction direction) {
        return this.container.m_7071_(direction);
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction direction) {
        return this.container.m_7155_(slot, itemStack, direction);
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        return this.container.m_7157_(slot, itemStack, direction);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)TRANSLATION_KEY);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new CollectorStationMenu(windowId, playerInventory, this, this.containerData);
    }
}

