/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.scraptechworkshop.block.collectorstation.CollectorStationBlock;
import de.markusbordihn.scraptechworkshop.block.entity.collectorstation.CollectorStationBlockEntity;
import de.markusbordihn.scraptechworkshop.client.entity.ClientCollectorStationRobotManager;
import de.markusbordihn.scraptechworkshop.client.renderer.blockentity.collectorstation.RobotStatusHandler;
import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.data.robot.RobotRenderInfo;
import de.markusbordihn.scraptechworkshop.entity.BaseRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.entity.collectorstationrobot.CollectorStationRobotStaticEntity;
import de.markusbordihn.scraptechworkshop.registry.entity.CollectorStationRobotEntityRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CollectorStationBlockEntityRenderer
implements BlockEntityRenderer<CollectorStationBlockEntity> {
    private static final float ROBOT_SCALE = 0.75f;
    private CollectorStationRobotStaticEntity cachedRobotEntity;

    public CollectorStationBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CollectorStationBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        CollectorStationRobotEntity robot;
        Level level = blockEntity.m_58904_();
        if (level == null || !(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        CollectorStationStatus status = blockEntity.getStatus();
        BlockPos blockPos = blockEntity.m_58899_();
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)CollectorStationBlock.FACING);
        ClientCollectorStationRobotManager.updateRobot(clientLevel, blockPos, facing, status);
        if (status.isRobotActive() && (robot = ClientCollectorStationRobotManager.getRobot(blockPos)) != null && !robot.m_213877_()) {
            return;
        }
        float animationTime = ((float)level.m_46467_() + partialTick) * 0.05f;
        float stationCenterX = 0.5f;
        float stationCenterZ = 0.5f;
        RobotStatusHandler handler = RobotStatusHandler.getHandler(status);
        if (handler == null) {
            return;
        }
        RobotRenderInfo renderInfo = handler.calculateRenderInfo(blockEntity, level, blockPos, facing, stationCenterX, stationCenterZ, animationTime, partialTick);
        if (renderInfo == null) {
            return;
        }
        handler.spawnParticles(level, blockPos, renderInfo, partialTick);
        poseStack.m_85836_();
        poseStack.m_252880_(renderInfo.offsetX(), renderInfo.offsetY(), renderInfo.offsetZ());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(renderInfo.yaw()));
        if (renderInfo.pitch() != 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(renderInfo.pitch()));
        }
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        CollectorStationRobotStaticEntity robotEntity = this.getOrCreateRobotEntity(level);
        if (robotEntity != null) {
            robotEntity.f_19797_ = (int)level.m_46467_();
            robotEntity.setStatus(status);
            double worldX = (float)blockPos.m_123341_() + renderInfo.offsetX();
            double worldY = (float)blockPos.m_123342_() + renderInfo.offsetY();
            double worldZ = (float)blockPos.m_123343_() + renderInfo.offsetZ();
            robotEntity.m_6034_(worldX, worldY, worldZ);
            Minecraft minecraft = Minecraft.m_91087_();
            EntityRenderDispatcher dispatcher = minecraft.m_91290_();
            EntityRenderer renderer = dispatcher.m_114382_((Entity)robotEntity);
            renderer.m_7392_((Entity)robotEntity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        }
        poseStack.m_85849_();
    }

    private CollectorStationRobotStaticEntity getOrCreateRobotEntity(Level level) {
        if (this.cachedRobotEntity == null && level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            this.cachedRobotEntity = new CollectorStationRobotStaticEntity((EntityType<? extends BaseRobotEntity>)CollectorStationRobotEntityRegistry.COLLECTOR_STATION_ROBOT_STATIC_ENTITY_TYPE, (Level)clientLevel);
            this.cachedRobotEntity.m_6034_(0.0, 0.0, 0.0);
        }
        return this.cachedRobotEntity;
    }

    public int m_142163_() {
        return 48;
    }
}

