/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.renderer.hololog;

import de.markusbordihn.scraptechworkshop.client.renderer.hololog.HoloLogPlaybackBase;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HoloLogPlayerManager {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, HoloLogPlaybackBase> ACTIVE_PLAYERS = new HashMap<UUID, HoloLogPlaybackBase>();
    private static final Map<String, UUID> ACTIVE_HOLOLOG_KEYS = new HashMap<String, UUID>();

    private HoloLogPlayerManager() {
    }

    private static String createKey(ResourceLocation holoLogId, Class<? extends HoloLogPlaybackBase> playerType) {
        return holoLogId.toString() + ":" + playerType.getSimpleName();
    }

    public static UUID register(HoloLogPlaybackBase player, ResourceLocation holoLogId) {
        String key = HoloLogPlayerManager.createKey(holoLogId, player.getClass());
        UUID existingPlayerId = ACTIVE_HOLOLOG_KEYS.get(key);
        if (existingPlayerId != null && ACTIVE_PLAYERS.containsKey(existingPlayerId)) {
            log.debug("Hololog {} with type {} is already playing with ID {}, reusing existing player", (Object)holoLogId, (Object)player.getClass().getSimpleName(), (Object)existingPlayerId);
            return existingPlayerId;
        }
        UUID id = UUID.randomUUID();
        ACTIVE_PLAYERS.put(id, player);
        ACTIVE_HOLOLOG_KEYS.put(key, id);
        log.info("Registered {} player {} for hololog: {}", (Object)player.getClass().getSimpleName(), (Object)id, (Object)holoLogId);
        return id;
    }

    public static HoloLogPlaybackBase get(UUID playerId) {
        return ACTIVE_PLAYERS.get(playerId);
    }

    public static void stopAll() {
        ACTIVE_PLAYERS.values().forEach(player -> player.stop());
        ACTIVE_PLAYERS.clear();
        ACTIVE_HOLOLOG_KEYS.clear();
        log.debug("Stopped all hololog players");
    }

    public static void tickAll() {
        ACTIVE_PLAYERS.values().removeIf(player -> {
            boolean shouldRemove;
            if (player.isPlaying()) {
                player.tick();
            }
            if (shouldRemove = player.isStopped()) {
                log.debug("Removing completed hololog player");
            }
            return shouldRemove;
        });
    }
}

