/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.pathfinding.ClientSideMovement;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ReturnToStationGoal
extends Goal {
    private static final double TELEPORT_DISTANCE_XZ = 64.0;
    private static final double TELEPORT_HEIGHT_DIFF = 2.0;
    private static final double REACH_DISTANCE = 0.3;
    private static final double LOOK_AHEAD_DISTANCE = 3.0;
    private static final int STUCK_THRESHOLD = 100;
    private final CollectorStationRobotEntity robot;
    private final double speedModifier;
    private int stuckCounter = 0;
    private int rotationDelay = 0;
    private double targetX;
    private double targetY;
    private double targetZ;

    public ReturnToStationGoal(CollectorStationRobotEntity robot, double speedModifier) {
        this.robot = robot;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.robot.getStatus() == CollectorStationStatus.RETURNING && this.robot.getStationPos() != null && !this.robot.getStationPos().equals((Object)BlockPos.f_121853_);
    }

    public boolean m_8045_() {
        BlockPos stationPos = this.robot.getStationPos();
        if (stationPos == null) {
            return false;
        }
        double distance = this.robot.m_20182_().m_82554_(new Vec3(this.targetX, this.targetY, this.targetZ));
        return this.robot.getStatus() == CollectorStationStatus.RETURNING && distance > 0.3;
    }

    public void m_8056_() {
        this.stuckCounter = 0;
        this.rotationDelay = 10;
        BlockPos stationPos = this.robot.getStationPos();
        if (stationPos == null) {
            return;
        }
        this.targetX = (double)stationPos.m_123341_() + 0.5;
        this.targetY = stationPos.m_123342_();
        this.targetZ = (double)stationPos.m_123343_() + 0.5;
        if (this.shouldTeleport()) {
            this.teleportToStation();
            this.rotationDelay = 20;
        }
    }

    public void m_8041_() {
        this.robot.m_20256_(Vec3.f_82478_);
        this.robot.m_7910_(0.0f);
        this.robot.setMovingFromGoal(false);
    }

    public void m_8037_() {
        if (this.robot.getStationPos() == null) {
            return;
        }
        double distance = this.robot.m_20182_().m_82554_(new Vec3(this.targetX, this.targetY, this.targetZ));
        if (distance < 0.3) {
            this.m_8041_();
            return;
        }
        if (this.rotationDelay > 0) {
            --this.rotationDelay;
            this.robot.m_20334_(0.0, this.robot.m_20184_().f_82480_, 0.0);
            this.robot.m_7910_(0.0f);
            this.robot.setMovingFromGoal(false);
            this.robot.m_21563_().m_24946_(this.targetX, this.targetY, this.targetZ);
            return;
        }
        boolean isMoving = ClientSideMovement.moveTowards((Mob)this.robot, this.targetX, this.targetY, this.targetZ, this.speedModifier * 0.04);
        this.robot.setMovingFromGoal(isMoving);
        if (!isMoving) {
            this.handleStuck();
        } else {
            this.stuckCounter = 0;
            this.updateLookDirection();
        }
    }

    private boolean shouldTeleport() {
        double distanceXZ = Math.sqrt(Math.pow(this.targetX - this.robot.m_20185_(), 2.0) + Math.pow(this.targetZ - this.robot.m_20189_(), 2.0));
        double heightDiff = Math.abs(this.targetY - this.robot.m_20186_());
        return distanceXZ > 64.0 || heightDiff > 2.0;
    }

    private void teleportToStation() {
        Vec3 safePos = ClientSideMovement.findGroundPosition(this.robot.m_9236_(), this.targetX, this.targetY, this.targetZ, 5);
        if (safePos != null) {
            this.robot.m_6034_(safePos.f_82479_, safePos.f_82480_, safePos.f_82481_);
        }
    }

    private void handleStuck() {
        ++this.stuckCounter;
        if (this.stuckCounter >= 100 && this.shouldTeleport()) {
            this.teleportToStation();
            this.stuckCounter = 0;
            this.rotationDelay = 10;
        }
    }

    private void updateLookDirection() {
        this.robot.m_21566_().m_6849_(this.targetX, this.targetY, this.targetZ, this.speedModifier);
        double dx = this.targetX - this.robot.m_20185_();
        double dy = this.targetY - this.robot.m_20186_();
        double dz = this.targetZ - this.robot.m_20189_();
        double dist = Math.sqrt(dx * dx + dz * dz);
        if (dist > 0.1) {
            double lookX = this.robot.m_20185_() + dx / dist * 3.0;
            double lookY = this.robot.m_20188_() + Math.max(0.0, dy * 0.3);
            double lookZ = this.robot.m_20189_() + dz / dist * 3.0;
            this.robot.m_21563_().m_24946_(lookX, lookY, lookZ);
        }
    }
}

