/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.loot;

import de.markusbordihn.scraptechworkshop.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapLootGenerator {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[ScrapLootGenerator]";
    private static final Random RANDOM = new Random();

    public static List<ItemStack> generateScrapForBiome(Level level, BlockPos pos, String biomeKey) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        int itemCount = 1 + RANDOM.nextInt(3);
        for (int i = 0; i < itemCount; ++i) {
            ItemStack scrap;
            ItemStack itemStack = scrap = RANDOM.nextInt(100) < 20 ? ScrapLootGenerator.generateFishingJunk() : ScrapLootGenerator.generateSingleScrap(level, pos, biomeKey);
            if (scrap.m_41619_()) continue;
            loot.add(scrap);
        }
        log.debug("{} Generated {} scrap items for biome {} at {}", (Object)LOG_PREFIX, (Object)loot.size(), (Object)biomeKey, (Object)pos);
        return loot;
    }

    private static ItemStack generateFishingJunk() {
        return switch (RANDOM.nextInt(15)) {
            case 0 -> new ItemStack((ItemLike)Items.f_42454_, 1);
            case 1 -> new ItemStack((ItemLike)Items.f_42463_, 1);
            case 2 -> new ItemStack((ItemLike)Items.f_42583_, 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)Items.f_42398_, 1 + RANDOM.nextInt(3));
            case 4 -> new ItemStack((ItemLike)Items.f_42401_, 1 + RANDOM.nextInt(3));
            case 5 -> new ItemStack((ItemLike)Items.f_42399_, 1);
            case 6 -> new ItemStack((ItemLike)Items.f_42590_, 1 + RANDOM.nextInt(2));
            case 7 -> new ItemStack((ItemLike)Items.f_42500_, 1 + RANDOM.nextInt(2));
            case 8 -> new ItemStack((ItemLike)Items.f_42109_, 1);
            case 9 -> new ItemStack((ItemLike)Items.f_42532_, 1 + RANDOM.nextInt(2));
            case 10 -> new ItemStack((ItemLike)Items.f_41911_, 1 + RANDOM.nextInt(4));
            case 11 -> new ItemStack((ItemLike)Items.f_42533_, 1 + RANDOM.nextInt(2));
            case 12 -> new ItemStack((ItemLike)Items.f_42094_, 1);
            case 13 -> new ItemStack((ItemLike)Items.f_42402_, 1 + RANDOM.nextInt(2));
            default -> new ItemStack((ItemLike)Items.f_42398_, 1);
        };
    }

    private static ItemStack generateSingleScrap(Level level, BlockPos pos, String biomeKey) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        if (biome.m_198904_(pos)) {
            return ScrapLootGenerator.generateColdBiomeScrap();
        }
        if (biome.m_47554_() > 1.0f) {
            return ScrapLootGenerator.generateHotBiomeScrap();
        }
        if (biomeKey.contains("ocean") || biomeKey.contains("river") || biomeKey.contains("beach")) {
            return ScrapLootGenerator.generateWaterBiomeScrap();
        }
        if (biomeKey.contains("desert")) {
            return ScrapLootGenerator.generateDesertScrap();
        }
        if (biomeKey.contains("jungle")) {
            return ScrapLootGenerator.generateJungleScrap();
        }
        if (biomeKey.contains("forest") || biomeKey.contains("taiga")) {
            return ScrapLootGenerator.generateForestScrap();
        }
        if (biomeKey.contains("mountain") || biomeKey.contains("hill")) {
            return ScrapLootGenerator.generateMountainScrap();
        }
        if (biomeKey.contains("swamp")) {
            return ScrapLootGenerator.generateSwampScrap();
        }
        if (biomeKey.contains("nether")) {
            return ScrapLootGenerator.generateNetherScrap();
        }
        if (biomeKey.contains("end")) {
            return ScrapLootGenerator.generateEndScrap();
        }
        return ScrapLootGenerator.generateGenericScrap();
    }

    private static ItemStack generateColdBiomeScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.IRON_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1);
        };
    }

    private static ItemStack generateHotBiomeScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1);
            case 2 -> new ItemStack((ItemLike)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static ItemStack generateWaterBiomeScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new ItemStack((ItemLike)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1);
            case 4 -> new ItemStack((ItemLike)ModItems.FASTENER_SCRAP.get(), 2 + RANDOM.nextInt(4));
            default -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1);
        };
    }

    private static ItemStack generateDesertScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.CIRCUIT_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.GOLD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static ItemStack generateJungleScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.BIO_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new ItemStack((ItemLike)ModItems.FIBER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.BIO_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static ItemStack generateForestScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 3 -> new ItemStack((ItemLike)ModItems.IRON_SCRAP.get(), 1);
            case 4 -> new ItemStack((ItemLike)ModItems.COPPER_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1);
        };
    }

    private static ItemStack generateMountainScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.IRON_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.COPPER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.MINERAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 4 -> new ItemStack((ItemLike)ModItems.GOLD_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static ItemStack generateSwampScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 2 + RANDOM.nextInt(4));
            case 1 -> new ItemStack((ItemLike)ModItems.BIO_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 2 -> new ItemStack((ItemLike)ModItems.FASTENER_SCRAP.get(), 1 + RANDOM.nextInt(4));
            case 3 -> new ItemStack((ItemLike)ModItems.RUBBER_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
        };
    }

    private static ItemStack generateNetherScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 2 + RANDOM.nextInt(3));
            case 1 -> new ItemStack((ItemLike)ModItems.GOLD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.COIL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)Items.f_42419_, 1);
            default -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }

    private static ItemStack generateEndScrap() {
        return switch (RANDOM.nextInt(5)) {
            case 0 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 2 + RANDOM.nextInt(4));
            case 1 -> new ItemStack((ItemLike)ModItems.CRYSTAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.LUMINOUS_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 3 -> new ItemStack((ItemLike)ModItems.ENERGY_CELL_SCRAP.get(), 1);
            default -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(3));
        };
    }

    private static ItemStack generateGenericScrap() {
        return switch (RANDOM.nextInt(6)) {
            case 0 -> new ItemStack((ItemLike)ModItems.METAL_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 1 -> new ItemStack((ItemLike)ModItems.TECH_SCRAP.get(), 1 + RANDOM.nextInt(2));
            case 2 -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 3 -> new ItemStack((ItemLike)ModItems.FASTENER_SCRAP.get(), 1 + RANDOM.nextInt(3));
            case 4 -> new ItemStack((ItemLike)ModItems.WOOD_SCRAP.get(), 1 + RANDOM.nextInt(2));
            default -> new ItemStack((ItemLike)ModItems.ALLOY_SCRAP.get(), 1 + RANDOM.nextInt(2));
        };
    }
}

