/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuManager {
    private static final Logger log = LogManager.getLogger((String)"ScrapTechWorkshop");
    private static MenuOpener menuOpener;

    private MenuManager() {
    }

    public static void setMenuOpener(MenuOpener opener) {
        if (menuOpener != null) {
            log.warn("MenuOpener already set! Overwriting with: {}", (Object)opener.getClass().getSimpleName());
        }
        menuOpener = opener;
        log.info("MenuOpener initialized: {}", (Object)opener.getClass().getSimpleName());
    }

    public static void openMenu(Player player, BlockEntity blockEntity) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openBlockEntityMenu(player, blockEntity);
    }

    public static void openMenu(Player player, ItemStack itemStack, InteractionHand hand) {
        if (menuOpener == null) {
            log.error("MenuOpener not initialized! Call setMenuOpener() during mod initialization.");
            return;
        }
        menuOpener.openItemMenu(player, itemStack, hand);
    }

    public static interface MenuOpener {
        public void openBlockEntityMenu(Player var1, BlockEntity var2);

        public void openItemMenu(Player var1, ItemStack var2, InteractionHand var3);
    }
}

