/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu.multitool;

import de.markusbordihn.scraptechworkshop.config.MultitoolConfig;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MultitoolBatteryInfo {
    private MultitoolBatteryInfo() {
    }

    public static int getCurrentEnergy(SimpleContainer toolContainer) {
        ItemStack battery = toolContainer.m_8020_(0);
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            return batteryEnergy <= 1 ? 0 : batteryEnergy;
        }
        return 0;
    }

    public static int getMaxEnergy(SimpleContainer toolContainer) {
        ItemStack battery = toolContainer.m_8020_(0);
        if (battery.m_41720_() instanceof EnergyCellItem) {
            return 5000;
        }
        return MultitoolConfig.energyMax;
    }

    public static int getPercentage(SimpleContainer toolContainer) {
        ItemStack battery = toolContainer.m_8020_(0);
        Item item = battery.m_41720_();
        if (item instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)item;
            int batteryEnergy = batteryItem.getEnergy(battery);
            if (batteryEnergy <= 1) {
                return 0;
            }
            return Math.round(batteryItem.getEnergyPercentage(battery) * 100.0f);
        }
        return 0;
    }
}

