/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.processing;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShovelInteractionHandler {
    public static InteractionResult processInteraction(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            return ShovelInteractionHandler.extinguishCampfire(context, level, pos, state);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult createPath(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        BlockState aboveState = level.m_8055_(blockPos.m_7494_());
        if (!aboveState.m_60795_()) {
            return InteractionResult.PASS;
        }
        BlockState newState = Blocks.f_152481_.m_49966_();
        Player player = context.m_43723_();
        level.m_5594_(player, blockPos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            level.m_7731_(blockPos, newState, 11);
            level.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockPos, context.m_43722_());
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static InteractionResult extinguishCampfire(UseOnContext context, Level level, BlockPos blockPos, BlockState blockState) {
        Player player = context.m_43723_();
        if (!level.f_46443_) {
            level.m_5898_(null, 1009, blockPos, 0);
        }
        CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)blockPos, (BlockState)blockState);
        BlockState newState = (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        level.m_7731_(blockPos, newState, 11);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

