/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.rechargestation;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.rechargestation.RechargeStationContainer;
import de.markusbordihn.scraptechworkshop.block.rechargestation.RechargeStationBlock;
import de.markusbordihn.scraptechworkshop.data.rechargestation.RechargeStationStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.RechargeStationMenu;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3913;

public class RechargeStationBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerConsumer {
    public static final String ID = "recharge_station";
    private static final int ENERGY_CAPACITY_MAH = 10000;
    private static final int ENERGY_CHARGE_INTERVAL = 5;
    private static final int ENERGY_CONSUMPTION_PER_TICK = 5;
    private static final int RECHARGE_RATE = 5;
    private static final int STATUS_CHANGE_DELAY = 20;
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String STATUS_DELAY_TIMER_TAG = "StatusDelayTimer";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recharge_station";
    public static class_2591<RechargeStationBlockEntity> TYPE;
    private final RechargeStationContainer container;
    private final int tickOffset;
    private int progress = 0;
    private int maxProgress = 100;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> RechargeStationBlockEntity.this.progress;
                case 1 -> RechargeStationBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    RechargeStationBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RechargeStationBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private int tickCounter = 0;
    private int statusDelayTimer = 0;
    private RechargeStationStatus pendingStatus = null;

    public RechargeStationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new RechargeStationContainer(2, this::method_5431);
        this.tickOffset = Math.abs((blockPos.method_10263() * 31 + blockPos.method_10264() * 17 + blockPos.method_10260() * 13) % 5);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, RechargeStationBlockEntity blockEntity) {
        class_1799 inputItem;
        if (level.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        if ((blockEntity.tickCounter + blockEntity.tickOffset) % 5 == 0) {
            blockEntity.chargeFromBattery(blockEntity.getEnergyTransferRate());
        }
        RechargeStationStatus currentStatus = (RechargeStationStatus)((Object)blockState.method_11654(RechargeStationBlock.STATUS));
        boolean hasEnoughEnergy = blockEntity.hasStableEnergy(5);
        RechargeStationStatus newStatus = RechargeStationBlockEntity.determineStatus(hasEnoughEnergy, inputItem = blockEntity.container.method_5438(0));
        if (newStatus != currentStatus) {
            if (blockEntity.pendingStatus == newStatus) {
                ++blockEntity.statusDelayTimer;
                if (blockEntity.statusDelayTimer >= 20) {
                    level.method_8652(blockPos, (class_2680)blockState.method_11657(RechargeStationBlock.STATUS, (Comparable)((Object)newStatus)), 3);
                    blockEntity.progress = 0;
                    blockEntity.statusDelayTimer = 0;
                    blockEntity.pendingStatus = null;
                }
            } else {
                blockEntity.pendingStatus = newStatus;
                blockEntity.statusDelayTimer = 0;
            }
        } else {
            blockEntity.statusDelayTimer = 0;
            blockEntity.pendingStatus = null;
        }
        if (newStatus == RechargeStationStatus.CHARGING && hasEnoughEnergy) {
            if (inputItem.method_7909() instanceof EmptyEnergyCellItem) {
                class_1799 chargedCell = new class_1799((class_1935)ModItems.ENERGY_CELL.get());
                class_1792 class_17922 = chargedCell.method_7909();
                if (class_17922 instanceof EnergyCellItem) {
                    EnergyCellItem energyCellItem = (EnergyCellItem)class_17922;
                    energyCellItem.setEnergy(chargedCell, 5);
                    blockEntity.container.method_5447(0, chargedCell);
                    blockEntity.consumeEnergy(5);
                    blockEntity.progress = 1;
                    blockEntity.maxProgress = 100;
                    blockEntity.method_5431();
                    if (blockEntity.tickCounter % 10 == 0) {
                        RechargeStationBlockEntity.spawnChargingParticles(level, blockPos, blockState);
                    }
                    if (blockEntity.tickCounter % 20 == 0) {
                        RechargeStationBlockEntity.playChargingSound(level, blockPos);
                    }
                }
            } else {
                class_1792 chargedCell = inputItem.method_7909();
                if (chargedCell instanceof EnergyCellItem) {
                    int maxBatteryEnergy;
                    EnergyCellItem batteryItem = (EnergyCellItem)chargedCell;
                    int currentBatteryEnergy = batteryItem.getEnergy(inputItem);
                    if (currentBatteryEnergy < (maxBatteryEnergy = 5000)) {
                        int energyToTransfer = Math.min(5, maxBatteryEnergy - currentBatteryEnergy);
                        batteryItem.setEnergy(inputItem, currentBatteryEnergy + energyToTransfer);
                        blockEntity.consumeEnergy(5);
                        blockEntity.progress = currentBatteryEnergy * 100 / maxBatteryEnergy;
                        blockEntity.maxProgress = 100;
                        blockEntity.method_5431();
                        if (blockEntity.tickCounter % 10 == 0) {
                            RechargeStationBlockEntity.spawnChargingParticles(level, blockPos, blockState);
                        }
                        if (blockEntity.tickCounter % 20 == 0) {
                            RechargeStationBlockEntity.playChargingSound(level, blockPos);
                        }
                    } else {
                        level.method_8652(blockPos, (class_2680)blockState.method_11657(RechargeStationBlock.STATUS, (Comparable)((Object)RechargeStationStatus.DONE)), 3);
                    }
                }
            }
        }
        if (newStatus == RechargeStationStatus.DONE || newStatus == RechargeStationStatus.IDLE) {
            blockEntity.progress = 0;
        }
    }

    private static RechargeStationStatus determineStatus(boolean hasEnoughEnergy, class_1799 inputItem) {
        if (!hasEnoughEnergy) {
            return RechargeStationStatus.NO_POWER;
        }
        if (inputItem.method_7960()) {
            return RechargeStationStatus.IDLE;
        }
        if (inputItem.method_7909() instanceof EmptyEnergyCellItem) {
            return RechargeStationStatus.CHARGING;
        }
        class_1792 class_17922 = inputItem.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            int maxEnergy;
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int currentEnergy = batteryItem.getEnergy(inputItem);
            if (currentEnergy >= (maxEnergy = 5000)) {
                return RechargeStationStatus.DONE;
            }
            return RechargeStationStatus.CHARGING;
        }
        return RechargeStationStatus.IDLE;
    }

    private static void spawnChargingParticles(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            double x = (double)blockPos.method_10263() + 0.5;
            double z = (double)blockPos.method_10260() + 0.5;
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)RechargeStationBlock.FACING);
            double offsetFromCenter = 0.15;
            switch (facing) {
                case field_11043: {
                    z -= offsetFromCenter;
                    break;
                }
                case field_11035: {
                    z += offsetFromCenter;
                    break;
                }
                case field_11039: {
                    x -= offsetFromCenter;
                    break;
                }
                case field_11034: {
                    x += offsetFromCenter;
                    break;
                }
            }
            for (int i = 0; i < 2; ++i) {
                double offsetX = (level.field_9229.method_43058() - 0.5) * 0.2;
                double offsetZ = (level.field_9229.method_43058() - 0.5) * 0.2;
                serverLevel.method_14199((class_2394)class_2398.field_29644, x + offsetX, (double)blockPos.method_10264() + 0.75, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
                serverLevel.method_14199((class_2394)class_2398.field_29644, x + offsetX, (double)blockPos.method_10264() + 0.2, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
        }
    }

    private static void playChargingSound(class_1937 level, class_2338 blockPos) {
        level.method_8396(null, blockPos, class_3417.field_15045, class_3419.field_15245, 0.15f, 1.8f);
    }

    public RechargeStationContainer getContainer() {
        return this.container;
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.container.getItems();
    }

    @Override
    protected class_1278 getContainerDelegate() {
        return this.container;
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.progress = compoundTag.method_10550(PROGRESS_TAG);
        this.maxProgress = compoundTag.method_10550(MAX_PROGRESS_TAG);
        this.statusDelayTimer = compoundTag.method_10550(STATUS_DELAY_TIMER_TAG);
        this.loadEnergyPowerConsumer(compoundTag);
        this.energyData = new EnergyPowerData(this.energyData.currentEnergy(), this.container.method_5438(1), this.energyData.debounceData());
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(PROGRESS_TAG, this.progress);
        compoundTag.method_10569(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.method_10569(STATUS_DELAY_TIMER_TAG, this.statusDelayTimer);
        this.saveEnergyPowerConsumer(compoundTag);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new RechargeStationMenu(windowId, playerInventory, this, this.containerData);
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return new EnergyPowerData(this.energyData.currentEnergy(), this.container.method_5438(1), this.energyData.debounceData());
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        this.energyData = new EnergyPowerData(data.currentEnergy(), data.battery(), data.debounceData());
        this.container.method_5447(1, data.battery());
        this.method_5431();
    }

    @Override
    public int getEnergyCapacity() {
        return 10000;
    }

    @Override
    public void markDirty() {
        this.method_5431();
    }

    public class_1799 getInputItem() {
        return this.container.method_5438(0);
    }

    public int getProgress() {
        return this.progress;
    }
}

