/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity.windturbine;

import de.markusbordihn.scraptechworkshop.block.entity.AbstractWorkshopBlockEntity;
import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineContainer;
import de.markusbordihn.scraptechworkshop.block.windturbine.ScrapWindTurbineBlock;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.environment.WindCalculator;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapWindTurbineMenu;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapWindTurbineBlockEntity
extends AbstractWorkshopBlockEntity
implements EnergyPowerGenerator {
    public static final String ID = "scrap_wind_turbine";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final int ENERGY_CAPACITY_MAH = 5000;
    private static final int ENERGY_GENERATION_INTERVAL = 20;
    private static final int BATTERY_CHARGE_INTERVAL = 5;
    private static final int ENERGY_DISTRIBUTION_INTERVAL = 1;
    private static final int WIND_CHECK_INTERVAL = 200;
    private static final String WIND_SPEED_TAG = "WindSpeed";
    private static final String POWER_GENERATION_TAG = "PowerGeneration";
    private static final int WIND_SPEED_DATA_INDEX = 0;
    private static final int POWER_GENERATION_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.scrap_wind_turbine";
    public static class_2591<ScrapWindTurbineBlockEntity> TYPE;
    private final ScrapWindTurbineContainer container;
    private final int windCheckOffset;
    private int windSpeed = 0;
    private int powerGeneration = 0;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> ScrapWindTurbineBlockEntity.this.windSpeed;
                case 1 -> ScrapWindTurbineBlockEntity.this.powerGeneration;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    ScrapWindTurbineBlockEntity.this.windSpeed = value;
                    break;
                }
                case 1: {
                    ScrapWindTurbineBlockEntity.this.powerGeneration = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private EnergyPowerData energyData = EnergyPowerData.empty();
    private int tickCounter = 0;

    public ScrapWindTurbineBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
        this.container = new ScrapWindTurbineContainer(2, this::method_5431);
        this.windCheckOffset = Math.abs((blockPos.method_10263() * 31 + blockPos.method_10264() * 17 + blockPos.method_10260() * 13) % 200);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, ScrapWindTurbineBlockEntity blockEntity) {
        ScrapWindTurbineStatus newStatus;
        if (level.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        if ((blockEntity.tickCounter + blockEntity.windCheckOffset) % 200 == 0) {
            blockEntity.windSpeed = WindCalculator.calculateWindSpeed(level, blockPos.method_10084());
            blockEntity.powerGeneration = WindCalculator.calculatePowerGeneration(blockEntity.windSpeed);
        }
        if (blockEntity.powerGeneration > 0 && blockEntity.tickCounter % 20 == 0) {
            blockEntity.generateEnergy(blockEntity.powerGeneration);
        }
        if (blockEntity.tickCounter % 5 == 0) {
            blockEntity.chargeFromBattery(blockEntity.getEnergyTransferRate());
        }
        if (blockEntity.tickCounter % 1 == 0) {
            int adaptiveRate = blockEntity.getAdaptiveTransferRate(blockEntity.getEnergyTransferRate());
            blockEntity.distributeEnergy(level, blockPos, 1, adaptiveRate);
        }
        if ((newStatus = blockEntity.determineStatus()) != blockState.method_11654(ScrapWindTurbineBlock.STATUS)) {
            ScrapWindTurbineBlock.updateStatus(level, blockPos, newStatus);
        }
        if (blockEntity.tickCounter % 20 == 0) {
            blockEntity.method_5431();
        }
    }

    private ScrapWindTurbineStatus determineStatus() {
        if (this.field_11863 != null && !this.field_11863.method_8311(this.method_11016().method_10084())) {
            return ScrapWindTurbineStatus.ERROR;
        }
        if (this.windSpeed == 0) {
            return ScrapWindTurbineStatus.NO_WIND;
        }
        if (this.windSpeed < 30) {
            return ScrapWindTurbineStatus.LOW_WIND;
        }
        if (this.powerGeneration > 0) {
            return ScrapWindTurbineStatus.GENERATING;
        }
        return ScrapWindTurbineStatus.IDLE;
    }

    public int getWindSpeed() {
        return this.windSpeed;
    }

    public ScrapWindTurbineContainer getContainer() {
        return this.container;
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.container.getItems();
    }

    @Override
    protected class_1278 getContainerDelegate() {
        return this.container;
    }

    @Override
    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.windSpeed = compoundTag.method_10550(WIND_SPEED_TAG);
        this.powerGeneration = compoundTag.method_10550(POWER_GENERATION_TAG);
        this.loadEnergyPowerGenerator(compoundTag);
        this.energyData = new EnergyPowerData(this.energyData.currentEnergy(), this.container.method_5438(0), this.energyData.debounceData());
    }

    @Override
    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10569(WIND_SPEED_TAG, this.windSpeed);
        compoundTag.method_10569(POWER_GENERATION_TAG, this.powerGeneration);
        this.saveEnergyPowerGenerator(compoundTag);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new ScrapWindTurbineMenu(windowId, playerInventory, this, this.containerData);
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public EnergyPowerData getEnergyData() {
        return new EnergyPowerData(this.energyData.currentEnergy(), this.container.method_5438(0), this.energyData.debounceData());
    }

    @Override
    public void setEnergyData(EnergyPowerData data) {
        this.energyData = new EnergyPowerData(data.currentEnergy(), data.battery(), data.debounceData());
        this.container.method_5447(0, data.battery());
        this.method_5431();
    }

    @Override
    public int getEnergyCapacity() {
        return 5000;
    }

    @Override
    public boolean chargeFromBattery(int amount) {
        class_1792 class_17922;
        class_1799 battery = this.container.method_5438(0);
        if (battery.method_7960() || !((class_17922 = battery.method_7909()) instanceof EnergyCellItem)) {
            return false;
        }
        EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
        int spaceAvailable = this.getEnergyCapacity() - this.getCurrentEnergy();
        if (spaceAvailable <= 0) {
            return false;
        }
        int batteryEnergy = batteryItem.getEnergy(battery);
        if (batteryEnergy <= 1) {
            return false;
        }
        int energyToTransfer = Math.min(Math.min(amount, spaceAvailable), batteryEnergy - 1);
        if (energyToTransfer <= 0) {
            return false;
        }
        batteryItem.setEnergy(battery, batteryEnergy - energyToTransfer);
        this.setCurrentEnergy(this.getCurrentEnergy() + energyToTransfer);
        this.method_5431();
        return true;
    }

    @Override
    public void markDirty() {
        this.method_5431();
    }
}

