/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.Constants;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public abstract class BaseContainerScreen<T extends class_1703>
extends class_465<T> {
    protected BaseContainerScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
    }

    protected void renderDefaultBackground(class_332 guiGraphics, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_DEMO_BACKGROUND);
        int standardWidth = 176;
        int standardHeight = 166;
        int splitX = Math.min(width / 2, standardWidth / 2);
        int splitY = Math.min(height / 2, standardHeight / 2);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, Math.min(splitX, width), Math.min(splitY, height));
        if (width > splitX) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y, standardWidth - (width - splitX), 0, width - splitX, Math.min(splitY, height));
        }
        if (height > splitY) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + splitY, 0, standardHeight - (height - splitY), Math.min(splitX, width), height - splitY);
        }
        if (width > splitX && height > splitY) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x + splitX, y + splitY, standardWidth - (width - splitX), standardHeight - (height - splitY), width - splitX, height - splitY);
        }
    }

    protected void renderSlot(class_332 guiGraphics, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_INVENTORY);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x - 1, y - 1, 7, 7, 18, 18);
    }

    protected void renderSlots(class_332 guiGraphics, int x, int y, int columns, int rows) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.renderSlot(guiGraphics, x + column * 18, y + row * 18);
            }
        }
    }

    protected void renderPlayerInventoryAt(class_332 guiGraphics, int x, int y, int inventoryStartY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_INVENTORY);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY - 1, 7, 83, 162, 54);
        guiGraphics.method_25302(Constants.TEXTURE_INVENTORY, x + 7, y + inventoryStartY + 57, 7, 141, 162, 18);
    }

    protected void renderEnergyBar(class_332 guiGraphics, int x, int y, int barWidth, int barHeight, int currentEnergy, int maxEnergy) {
        guiGraphics.method_25294(x, y, x + barWidth, y + barHeight, -11184811);
        if (currentEnergy > 0 && maxEnergy > 0) {
            int energyBarHeight = (int)((float)currentEnergy / (float)maxEnergy * (float)barHeight);
            guiGraphics.method_25294(x, y + (barHeight - energyBarHeight), x + barWidth, y + barHeight, -16711936);
        }
    }

    protected void renderEnergyBarWithFrame(class_332 guiGraphics, int x, int y, int barWidth, int barHeight, int currentEnergy, int maxEnergy) {
        guiGraphics.method_25294(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, -7631989);
        this.renderEnergyBar(guiGraphics, x, y, barWidth, barHeight, currentEnergy, maxEnergy);
    }

    protected void renderProgressBar(class_332 guiGraphics, int x, int y, int width, int height, int current, int max, int color) {
        guiGraphics.method_25294(x, y, x + width, y + height, -11184811);
        if (max > 0 && current > 0) {
            int filledWidth = current * width / max;
            guiGraphics.method_25294(x, y, x + filledWidth, y + height, 0xFF000000 | color);
        }
        guiGraphics.method_25294(x, y, x + width, y + 1, -16777216);
        guiGraphics.method_25294(x, y + height - 1, x + width, y + height, -16777216);
        guiGraphics.method_25294(x, y, x + 1, y + height, -16777216);
        guiGraphics.method_25294(x + width - 1, y, x + width, y + height, -16777216);
    }

    protected void renderEnergyTooltip(class_332 guiGraphics, int mouseX, int mouseY, int currentEnergy, int maxEnergy) {
        this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, currentEnergy, maxEnergy, 3.7f);
    }

    protected void renderEnergyTooltip(class_332 guiGraphics, int mouseX, int mouseY, int currentEnergy, int maxEnergy, float voltage) {
        int percentage = maxEnergy > 0 ? currentEnergy * 100 / maxEnergy : 0;
        class_5250 tooltip = class_2561.method_43470((String)String.format("%d / %d mAh (%.1fV) - %d%%", currentEnergy, maxEnergy, Float.valueOf(voltage), percentage));
        guiGraphics.method_51438(this.field_22793, (class_2561)tooltip, mouseX, mouseY);
    }

    protected boolean isMouseOverEnergyBar(int mouseX, int mouseY, int barX, int barY, int barWidth, int barHeight) {
        return mouseX >= barX && mouseX <= barX + barWidth && mouseY >= barY && mouseY <= barY + barHeight;
    }

    protected void renderEnergyTab(class_332 guiGraphics, int x, int y, int tabWidth, int tabHeight) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Constants.TEXTURE_DEMO_BACKGROUND);
        int cornerHeight = Math.min(tabHeight / 2, 10);
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y, 0, 0, tabWidth, cornerHeight);
        int middleHeight = tabHeight - cornerHeight * 2;
        if (middleHeight > 0) {
            guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + cornerHeight, 0, 5, tabWidth, middleHeight);
        }
        guiGraphics.method_25302(Constants.TEXTURE_DEMO_BACKGROUND, x, y + tabHeight - cornerHeight, 0, 166 - cornerHeight, tabWidth, cornerHeight);
    }

    protected void renderEnergyPowerUI(class_332 guiGraphics, int x, int y, int batterySlotX, int batterySlotY, int energyBarX, int energyBarY, int energyBarWidth, int energyBarHeight, int currentEnergy, int energyCapacity) {
        int tabWidth = 26;
        int tabHeight = 93;
        int tabX = x - tabWidth;
        int tabY = y;
        this.renderEnergyTab(guiGraphics, tabX, tabY, tabWidth, tabHeight);
        this.renderSlot(guiGraphics, x + batterySlotX, y + batterySlotY);
        this.renderEnergyBarWithFrame(guiGraphics, x + energyBarX, y + energyBarY, energyBarWidth, energyBarHeight, currentEnergy, energyCapacity);
    }

    protected void renderEnergyPowerTooltips(class_332 guiGraphics, int mouseX, int mouseY, int leftPos, int topPos, int batterySlotX, int batterySlotY, int energyBarX, int energyBarY, int energyBarWidth, int energyBarHeight, int currentEnergy, int energyCapacity, String batteryTooltipKey, int batterySlotIndex) {
        int relativeX = mouseX - leftPos;
        int relativeY = mouseY - topPos;
        if (relativeX >= batterySlotX - 1 && relativeX <= batterySlotX + 17 && relativeY >= batterySlotY - 1 && relativeY <= batterySlotY + 17 && this.field_2797.method_7611(batterySlotIndex).method_7677().method_7960()) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)batteryTooltipKey), mouseX, mouseY);
        }
        if (this.isMouseOverEnergyBar(relativeX, relativeY, energyBarX, energyBarY, energyBarWidth, energyBarHeight)) {
            this.renderEnergyTooltip(guiGraphics, mouseX, mouseY, currentEnergy, energyCapacity);
        }
    }
}

