/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.screen.windturbine;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.scraptechworkshop.client.screen.BaseContainerScreen;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import de.markusbordihn.scraptechworkshop.menu.ScrapWindTurbineMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class ScrapWindTurbineScreen
extends BaseContainerScreen<ScrapWindTurbineMenu> {
    private static final String TRANSLATION_KEY_PREFIX = "gui.scrap_tech_workshop.scrap_wind_turbine.";
    private static final String TRANSLATION_WIND_SPEED = "gui.scrap_tech_workshop.scrap_wind_turbine.wind_speed";
    private static final String TRANSLATION_POWER_GEN = "gui.scrap_tech_workshop.scrap_wind_turbine.power_generation";
    private static final String TRANSLATION_BATTERY_SLOT = "gui.scrap_tech_workshop.scrap_wind_turbine.battery_slot";
    private static final String TRANSLATION_CHARGING_SLOT = "gui.scrap_tech_workshop.scrap_wind_turbine.charging_slot";
    private static final String TRANSLATION_STATUS_IDLE = "gui.scrap_tech_workshop.scrap_wind_turbine.status.idle";
    private static final String TRANSLATION_STATUS_NO_WIND = "gui.scrap_tech_workshop.scrap_wind_turbine.status.no_wind";
    private static final String TRANSLATION_STATUS_LOW_WIND = "gui.scrap_tech_workshop.scrap_wind_turbine.status.low_wind";
    private static final String TRANSLATION_STATUS_GENERATING = "gui.scrap_tech_workshop.scrap_wind_turbine.status.generating";
    private static final String TRANSLATION_STATUS_ERROR = "gui.scrap_tech_workshop.scrap_wind_turbine.status.error";
    private static final String TRANSLATION_STATUS_ERROR_HINT = "gui.scrap_tech_workshop.scrap_wind_turbine.status.error.hint";
    private static final String TRANSLATION_STATUS_LOW_WIND_HINT = "gui.scrap_tech_workshop.scrap_wind_turbine.status.low_wind.hint";
    private static final int SCREEN_WIDTH = 176;
    private static final int SCREEN_HEIGHT = 201;
    private static final int UI_LEFT_MARGIN = 8;
    private static final int WIND_SPEED_BAR_Y = 50;
    private static final int POWER_GEN_BAR_Y = 70;
    private static final int WIND_SPEED_TEXT_Y = 38;
    private static final int POWER_GEN_TEXT_Y = 58;
    private static final int STATUS_TEXT_Y = 78;
    private static final int HINT_TEXT_Y = 88;
    private static final int PROGRESS_BAR_WIDTH = 70;
    private static final int CHARGING_SLOT_ENERGY_BAR_OFFSET_Y = 20;
    private static final int ENERGY_BAR_X_OFFSET = -20;
    private static final int ENERGY_BAR_Y = 6;
    private static final int ENERGY_BAR_TOOLTIP_X_OFFSET = -20;
    private static final int ENERGY_BAR_TOOLTIP_Y = 26;
    private static final int ENERGY_BAR_WIDTH = 16;
    private static final int ENERGY_BAR_HEIGHT = 60;
    private float displayWindSpeed = 0.0f;
    private float displayPowerGen = 0.0f;
    private long lastFluctuationTime = 0L;

    public ScrapWindTurbineScreen(ScrapWindTurbineMenu menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_2792 = 176;
        this.field_2779 = 201;
        this.field_25270 = 107;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderDefaultBackground(guiGraphics, x, y, this.field_2792, this.field_2779);
        this.renderEnergyPowerUI(guiGraphics, x, y, -20, 6, -20, 26, 16, 60, ((ScrapWindTurbineMenu)this.field_2797).getEnergy(), ((ScrapWindTurbineMenu)this.field_2797).getEnergyCapacity());
        this.renderSlot(guiGraphics, x + 135, y + 43);
        int chargingSlotEnergy = this.getChargingBatteryEnergy();
        this.renderProgressBar(guiGraphics, x + 135 - 1, y + 43 + 20, 18, 2, chargingSlotEnergy, 5000, 16766720);
        this.updateFluctuatingValues();
        this.renderProgressBar(guiGraphics, x + 8, y + 50, 70, 4, (int)(this.displayWindSpeed * 10.0f), 250, 4890584);
        this.renderProgressBar(guiGraphics, x + 8, y + 70, 70, 4, (int)this.displayPowerGen, 50, 4905802);
        this.renderPlayerInventoryAt(guiGraphics, x, y, 119);
        this.renderInfoText(guiGraphics, x, y);
    }

    private void updateFluctuatingValues() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFluctuationTime > 1000L) {
            int baseWindSpeed = ((ScrapWindTurbineMenu)this.field_2797).getWindSpeed();
            int basePowerGen = ((ScrapWindTurbineMenu)this.field_2797).getPowerGeneration();
            if (baseWindSpeed > 0) {
                float fluctuation = (float)((Math.random() * 4.0 - 2.0) / 100.0);
                this.displayWindSpeed = (float)baseWindSpeed / 10.0f * (1.0f + fluctuation);
                this.displayPowerGen = (float)basePowerGen * (1.0f + fluctuation);
            } else {
                this.displayWindSpeed = 0.0f;
                this.displayPowerGen = 0.0f;
            }
            this.lastFluctuationTime = currentTime;
        }
        if (this.displayWindSpeed == 0.0f && ((ScrapWindTurbineMenu)this.field_2797).getWindSpeed() > 0) {
            this.displayWindSpeed = (float)((ScrapWindTurbineMenu)this.field_2797).getWindSpeed() / 10.0f;
            this.displayPowerGen = ((ScrapWindTurbineMenu)this.field_2797).getPowerGeneration();
        }
    }

    private void renderInfoText(class_332 guiGraphics, int x, int y) {
        class_5250 windSpeedText = class_2561.method_43469((String)TRANSLATION_WIND_SPEED, (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.displayWindSpeed))});
        class_5250 powerGenText = class_2561.method_43469((String)TRANSLATION_POWER_GEN, (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.displayPowerGen))});
        guiGraphics.method_51439(this.field_22793, (class_2561)windSpeedText, x + 8, y + 38, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, (class_2561)powerGenText, x + 8, y + 58, 0x404040, false);
        this.renderStatusInfo(guiGraphics, x, y);
    }

    private void renderStatusInfo(class_332 guiGraphics, int x, int y) {
        class_5250 statusText;
        ScrapWindTurbineStatus status = ((ScrapWindTurbineMenu)this.field_2797).getWindTurbineStatus();
        int color = 0x404040;
        switch (status) {
            case IDLE: {
                statusText = class_2561.method_43471((String)TRANSLATION_STATUS_IDLE);
                color = 0xAAAAAA;
                break;
            }
            case NO_WIND: {
                statusText = class_2561.method_43471((String)TRANSLATION_STATUS_NO_WIND);
                color = 0xFFAA00;
                break;
            }
            case LOW_WIND: {
                statusText = class_2561.method_43471((String)TRANSLATION_STATUS_LOW_WIND);
                color = 0xFFCC00;
                break;
            }
            case GENERATING: {
                statusText = class_2561.method_43471((String)TRANSLATION_STATUS_GENERATING);
                color = 65280;
                break;
            }
            case ERROR: {
                statusText = class_2561.method_43471((String)TRANSLATION_STATUS_ERROR);
                color = 0xFF0000;
                break;
            }
            default: {
                statusText = class_2561.method_43470((String)"Unknown");
            }
        }
        guiGraphics.method_51439(this.field_22793, (class_2561)statusText, x + 8, y + 78, color, false);
        if (status == ScrapWindTurbineStatus.ERROR) {
            class_5250 hintText = class_2561.method_43471((String)TRANSLATION_STATUS_ERROR_HINT);
            guiGraphics.method_51439(this.field_22793, (class_2561)hintText, x + 8, y + 88, 0xFF5555, false);
        } else if (status == ScrapWindTurbineStatus.LOW_WIND) {
            class_5250 hintText = class_2561.method_43471((String)TRANSLATION_STATUS_LOW_WIND_HINT);
            guiGraphics.method_51439(this.field_22793, (class_2561)hintText, x + 8, y + 88, 0xFFAA55, false);
        }
    }

    private int getChargingBatteryEnergy() {
        class_1792 item;
        class_1735 slot = ((ScrapWindTurbineMenu)this.field_2797).method_7611(((ScrapWindTurbineMenu)this.field_2797).getChargingBatterySlotIndex());
        if (slot != null && !slot.method_7677().method_7960() && (item = slot.method_7677().method_7909()) instanceof EnergyCellItem) {
            EnergyCellItem energyCell = (EnergyCellItem)item;
            return energyCell.getEnergy(slot.method_7677());
        }
        return 0;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderEnergyPowerTooltips(guiGraphics, mouseX, mouseY, x, y, -20, 6, -20, 26, 16, 60, ((ScrapWindTurbineMenu)this.field_2797).getEnergy(), ((ScrapWindTurbineMenu)this.field_2797).getEnergyCapacity(), TRANSLATION_BATTERY_SLOT, ((ScrapWindTurbineMenu)this.field_2797).getEnergyTabBatterySlotIndex());
        int relativeX = mouseX - x;
        int relativeY = mouseY - y;
        if (relativeX >= 135 && relativeX <= 151 && relativeY >= 43 && relativeY <= 59) {
            guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)TRANSLATION_CHARGING_SLOT), mouseX, mouseY);
        }
        super.method_2380(guiGraphics, mouseX, mouseY);
    }
}

