/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyDebounceData;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3913;

public interface EnergyPowerConsumer
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final String LAST_ENERGY_RECEIVE_TIME_TAG = "LastEnergyReceiveTime";
    public static final int DEFAULT_ENERGY_DEBOUNCE_THRESHOLD = 10;
    public static final int DEFAULT_ENERGY_DEBOUNCE_TICKS = 40;

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public class_1799 getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(class_1799 battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public class_3913 getEnergyPowerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerConsumer.this.getCurrentEnergy();
                    case 1 -> EnergyPowerConsumer.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    EnergyPowerConsumer.this.setCurrentEnergy(value);
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    default public boolean consumeEnergy(int amount) {
        if (this.getCurrentEnergy() >= amount) {
            this.setCurrentEnergy(this.getCurrentEnergy() - amount);
            return true;
        }
        return false;
    }

    default public boolean canAcceptExternalEnergy() {
        return this.getCurrentEnergy() < this.getEnergyCapacity();
    }

    default public int receiveEnergy(int amount, boolean simulate) {
        int capacity = this.getEnergyCapacity();
        int currentEnergy = this.getCurrentEnergy();
        int energyReceived = Math.min(amount, capacity - currentEnergy);
        if (!simulate && energyReceived > 0) {
            this.setCurrentEnergy(currentEnergy + energyReceived);
            this.updateEnergyReceiveTime();
        }
        return energyReceived;
    }

    default public void updateEnergyReceiveTime() {
        EnergyPowerData data = this.getEnergyData();
        this.setEnergyData(data.withDebounceData(data.debounceData().withReceiveTime(System.currentTimeMillis() / 50L, this.getCurrentEnergy())));
    }

    default public boolean hasStableEnergy(int requiredEnergy) {
        return this.hasStableEnergy(requiredEnergy, 10);
    }

    default public boolean hasStableEnergy(int requiredEnergy, int threshold) {
        int currentEnergy = this.getCurrentEnergy();
        if (currentEnergy < requiredEnergy) {
            return false;
        }
        return currentEnergy >= requiredEnergy + threshold || this.isReceivingEnergy(40);
    }

    default public boolean isReceivingEnergy(int debounceTicks) {
        long currentTime = System.currentTimeMillis() / 50L;
        return this.getEnergyData().debounceData().isReceivingEnergy(currentTime, debounceTicks);
    }

    default public void loadEnergyPowerConsumer(class_2487 compoundTag) {
        long lastReceiveTime;
        int energy = compoundTag.method_10550(ENERGY_TAG);
        class_1799 battery = class_1799.field_8037;
        if (compoundTag.method_10545(BATTERY_TAG)) {
            battery = class_1799.method_7915((class_2487)compoundTag.method_10562(BATTERY_TAG));
        }
        EnergyDebounceData debounceData = (lastReceiveTime = compoundTag.method_10537(LAST_ENERGY_RECEIVE_TIME_TAG)) > 0L ? new EnergyDebounceData(lastReceiveTime, energy) : EnergyDebounceData.empty();
        this.setEnergyData(new EnergyPowerData(energy, battery, debounceData));
    }

    default public void saveEnergyPowerConsumer(class_2487 compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.method_10569(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().method_7960()) {
            class_2487 batteryTag = new class_2487();
            data.battery().method_7953(batteryTag);
            compoundTag.method_10566(BATTERY_TAG, (class_2520)batteryTag);
        }
        if (data.debounceData() != null) {
            compoundTag.method_10544(LAST_ENERGY_RECEIVE_TIME_TAG, data.debounceData().lastEnergyReceiveTime());
        }
    }
}

