/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.energy;

import de.markusbordihn.scraptechworkshop.energy.EnergyBatteryHandler;
import de.markusbordihn.scraptechworkshop.energy.EnergyDebounceData;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerConsumer;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerData;
import de.markusbordihn.scraptechworkshop.item.ModItems;
import de.markusbordihn.scraptechworkshop.item.component.EmptyEnergyCellItem;
import de.markusbordihn.scraptechworkshop.item.component.EnergyCellItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3913;

public interface EnergyPowerGenerator
extends EnergyBatteryHandler {
    public static final String ENERGY_TAG = "Energy";
    public static final String BATTERY_TAG = "Battery";
    public static final int TICKS_PER_SECOND = 20;

    @Override
    public int getEnergyCapacity();

    @Override
    public void markDirty();

    public EnergyPowerData getEnergyData();

    public void setEnergyData(EnergyPowerData var1);

    @Override
    default public int getCurrentEnergy() {
        return this.getEnergyData().currentEnergy();
    }

    @Override
    default public void setCurrentEnergy(int energy) {
        this.setEnergyData(this.getEnergyData().withCurrentEnergy(energy));
    }

    @Override
    default public class_1799 getBattery() {
        return this.getEnergyData().battery();
    }

    @Override
    default public void setBattery(class_1799 battery) {
        this.setEnergyData(this.getEnergyData().withBattery(battery));
    }

    default public int getEnergyTransferRate() {
        return 50;
    }

    default public class_3913 getEnergyPowerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> EnergyPowerGenerator.this.getCurrentEnergy();
                    case 1 -> EnergyPowerGenerator.this.getEnergyCapacity();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                if (index == 0) {
                    EnergyPowerGenerator.this.setCurrentEnergy(value);
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    default public int getAdaptiveTransferRate(int baseTransferRate) {
        if (this.getCurrentEnergy() > baseTransferRate) {
            return baseTransferRate;
        }
        return Math.max(1, baseTransferRate / 20);
    }

    default public boolean generateEnergy(int amount) {
        int capacity;
        int currentEnergy = this.getCurrentEnergy();
        if (currentEnergy >= (capacity = this.getEnergyCapacity())) {
            return false;
        }
        int energyToAdd = Math.min(amount, capacity - currentEnergy);
        this.setCurrentEnergy(currentEnergy + energyToAdd);
        return true;
    }

    default public int extractEnergy(int amount, boolean simulate) {
        int currentEnergy = this.getCurrentEnergy();
        int energyExtracted = Math.min(amount, currentEnergy);
        if (!simulate && energyExtracted > 0) {
            this.setCurrentEnergy(currentEnergy - energyExtracted);
        }
        return energyExtracted;
    }

    default public void loadEnergyPowerGenerator(class_2487 compoundTag) {
        int energy = compoundTag.method_10550(ENERGY_TAG);
        class_1799 battery = class_1799.field_8037;
        if (compoundTag.method_10545(BATTERY_TAG)) {
            battery = class_1799.method_7915((class_2487)compoundTag.method_10562(BATTERY_TAG));
        }
        this.setEnergyData(new EnergyPowerData(energy, battery, EnergyDebounceData.empty()));
    }

    default public void saveEnergyPowerGenerator(class_2487 compoundTag) {
        EnergyPowerData data = this.getEnergyData();
        compoundTag.method_10569(ENERGY_TAG, data.currentEnergy());
        if (!data.battery().method_7960()) {
            class_2487 batteryTag = new class_2487();
            data.battery().method_7953(batteryTag);
            compoundTag.method_10566(BATTERY_TAG, (class_2520)batteryTag);
        }
    }

    default public int distributeToPlatformEnergySystem(class_1937 level, class_2338 blockPos, int availableEnergy, int maxTransferRate) {
        try {
            Class<?> distributorClass = Class.forName("de.markusbordihn.scraptechworkshop.energy.compat.EnergyDistributor");
            Method method = distributorClass.getMethod("distributeToAdjacentBlocks", class_1937.class, class_2338.class, Integer.TYPE, Integer.TYPE);
            Object result = method.invoke(null, level, blockPos, availableEnergy, maxTransferRate);
            return (Integer)result;
        }
        catch (Exception e) {
            return 0;
        }
    }

    default public int distributeEnergy(class_1937 level, class_2338 blockPos, int chargingBatterySlot, int maxTransferRate) {
        class_1263 container;
        class_1799 battery;
        int batterySpace;
        EnergyPowerGenerator energyPowerGenerator;
        if (level == null || level.field_9236) {
            return 0;
        }
        int availableEnergy = this.getCurrentEnergy();
        if (availableEnergy <= 0) {
            return 0;
        }
        int totalDistributed = 0;
        int platformDistributed = this.distributeToPlatformEnergySystem(level, blockPos, availableEnergy, maxTransferRate);
        if (platformDistributed > 0) {
            this.extractEnergy(platformDistributed, false);
            totalDistributed += platformDistributed;
            this.markDirty();
        }
        ArrayList<EnergyConsumerInfo> consumers = new ArrayList<EnergyConsumerInfo>();
        for (class_2350 direction : class_2350.values()) {
            int spaceAvailable;
            EnergyPowerConsumer consumer;
            class_2338 adjacentPos = blockPos.method_10093(direction);
            class_2586 blockEntity = level.method_8321(adjacentPos);
            if (!(blockEntity instanceof EnergyPowerConsumer) || !(consumer = (EnergyPowerConsumer)blockEntity).canAcceptExternalEnergy() || (spaceAvailable = consumer.getEnergyCapacity() - consumer.getCurrentEnergy()) <= 0) continue;
            consumers.add(new EnergyConsumerInfo(consumer, spaceAvailable));
        }
        if (chargingBatterySlot >= 0 && (energyPowerGenerator = this) instanceof class_1263 && (batterySpace = this.getBatterySpaceAvailable(battery = (container = (class_1263)energyPowerGenerator).method_5438(chargingBatterySlot))) > 0) {
            consumers.add(new EnergyConsumerInfo(container, chargingBatterySlot, battery, batterySpace));
        }
        if (consumers.isEmpty()) {
            return totalDistributed;
        }
        int totalSpace = consumers.stream().mapToInt(c -> c.spaceAvailable).sum();
        int energyToDistribute = Math.min(Math.min(availableEnergy - totalDistributed, maxTransferRate), totalSpace);
        if (energyToDistribute <= 0) {
            return totalDistributed;
        }
        int remainingEnergy = energyToDistribute;
        for (int i = 0; i < consumers.size(); ++i) {
            int energyForThis;
            EnergyConsumerInfo consumer = (EnergyConsumerInfo)consumers.get(i);
            if (i == consumers.size() - 1) {
                energyForThis = Math.min(remainingEnergy, consumer.spaceAvailable);
            } else {
                energyForThis = Math.min(energyToDistribute * consumer.spaceAvailable / totalSpace, consumer.spaceAvailable);
                energyForThis = Math.min(energyForThis, remainingEnergy);
            }
            if (energyForThis <= 0) continue;
            int actualTransferred = consumer.receiveEnergy(energyForThis);
            totalDistributed += actualTransferred;
            remainingEnergy -= actualTransferred;
        }
        if (totalDistributed > 0) {
            this.extractEnergy(totalDistributed, false);
            this.markDirty();
        }
        return totalDistributed;
    }

    default public int getBatterySpaceAvailable(class_1799 battery) {
        if (battery.method_7960()) {
            return 0;
        }
        if (battery.method_7909() instanceof EmptyEnergyCellItem) {
            return 5000;
        }
        class_1792 class_17922 = battery.method_7909();
        if (class_17922 instanceof EnergyCellItem) {
            EnergyCellItem batteryItem = (EnergyCellItem)class_17922;
            int currentEnergy = batteryItem.getEnergy(battery);
            return 5000 - currentEnergy;
        }
        return 0;
    }

    public static class EnergyConsumerInfo {
        private final EnergyPowerConsumer blockConsumer;
        private final class_1263 batteryContainer;
        private final int batterySlot;
        private final class_1799 battery;
        private final int spaceAvailable;

        public EnergyConsumerInfo(EnergyPowerConsumer consumer, int spaceAvailable) {
            this.blockConsumer = consumer;
            this.batteryContainer = null;
            this.batterySlot = -1;
            this.battery = null;
            this.spaceAvailable = spaceAvailable;
        }

        public EnergyConsumerInfo(class_1263 container, int slot, class_1799 battery, int spaceAvailable) {
            this.blockConsumer = null;
            this.batteryContainer = container;
            this.batterySlot = slot;
            this.battery = battery;
            this.spaceAvailable = spaceAvailable;
        }

        public int receiveEnergy(int amount) {
            if (this.blockConsumer != null) {
                return this.blockConsumer.receiveEnergy(amount, false);
            }
            if (this.battery != null && this.batteryContainer != null) {
                return this.chargeBatteryItem(this.batteryContainer, this.batterySlot, this.battery, amount);
            }
            return 0;
        }

        private int chargeBatteryItem(class_1263 container, int slot, class_1799 battery, int amount) {
            if (battery.method_7909() instanceof EmptyEnergyCellItem) {
                class_1799 chargedBattery = new class_1799((class_1935)ModItems.ENERGY_CELL.get());
                class_1792 class_17922 = chargedBattery.method_7909();
                if (class_17922 instanceof EnergyCellItem) {
                    EnergyCellItem energyCell = (EnergyCellItem)class_17922;
                    int energyToAdd = Math.min(amount, 5000);
                    energyCell.setEnergy(chargedBattery, energyToAdd);
                    container.method_5447(slot, chargedBattery);
                    return energyToAdd;
                }
            } else {
                class_1792 chargedBattery = battery.method_7909();
                if (chargedBattery instanceof EnergyCellItem) {
                    EnergyCellItem batteryItem = (EnergyCellItem)chargedBattery;
                    int currentEnergy = batteryItem.getEnergy(battery);
                    int energyToAdd = Math.min(amount, 5000 - currentEnergy);
                    batteryItem.setEnergy(battery, currentEnergy + energyToAdd);
                    return energyToAdd;
                }
            }
            return 0;
        }
    }
}

