/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity;

import de.markusbordihn.scraptechworkshop.registry.entity.MixedScrapRobotEntityRegistry;
import de.markusbordihn.scraptechworkshop.spawner.RobotSpawnConfig;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricEntitySpawnHandler {
    protected static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final RobotSpawnConfig CONFIG = RobotSpawnConfig.load("mixed_scrap_robot");

    private FabricEntitySpawnHandler() {
    }

    public static void registerSpawns() {
        if (!FabricEntitySpawnHandler.CONFIG.enabled) {
            log.info("Mixed Scrap Robot spawning is disabled in spawn config");
            return;
        }
        if (MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE == null) {
            log.error("Mixed Scrap Robot entity type is null, cannot register spawns");
            return;
        }
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(FabricEntitySpawnHandler.parseBiomeTag(FabricEntitySpawnHandler.CONFIG.biomes)), (class_1311)class_1311.field_6294, MixedScrapRobotEntityRegistry.MIXED_SCRAP_ROBOT_ENTITY_TYPE, (int)FabricEntitySpawnHandler.CONFIG.weight, (int)FabricEntitySpawnHandler.CONFIG.minGroup, (int)FabricEntitySpawnHandler.CONFIG.maxGroup);
        log.info("Registered Mixed Scrap Robot spawning (weight: {}, group: {}-{}, biomes: {}, minDistance: {})", (Object)FabricEntitySpawnHandler.CONFIG.weight, (Object)FabricEntitySpawnHandler.CONFIG.minGroup, (Object)FabricEntitySpawnHandler.CONFIG.maxGroup, (Object)FabricEntitySpawnHandler.CONFIG.biomes, (Object)FabricEntitySpawnHandler.CONFIG.minDistanceFromCenter);
    }

    private static class_6862<class_1959> parseBiomeTag(String tag) {
        String tagPath = tag.startsWith("#") ? tag.substring(1) : tag;
        String[] parts = tagPath.split(":");
        if (parts.length == 2) {
            return class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(parts[0], parts[1]));
        }
        return class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("minecraft", "is_overworld"));
    }

    public static int getMinDistanceFromCenter() {
        return FabricEntitySpawnHandler.CONFIG.minDistanceFromCenter;
    }

    public static int getDespawnDistance() {
        return FabricEntitySpawnHandler.CONFIG.despawnDistance;
    }
}

