/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot;

import de.markusbordihn.scraptechworkshop.data.collectorstation.CollectorStationStatus;
import de.markusbordihn.scraptechworkshop.entity.robot.collectorstationrobot.CollectorStationRobotEntity;
import de.markusbordihn.scraptechworkshop.pathfinding.ClientSideMovement;
import java.util.EnumSet;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class RandomCollectGoal
extends class_1352 {
    private static final int MIN_MOVE_INTERVAL = 100;
    private static final int MAX_MOVE_INTERVAL = 200;
    private static final int MIN_PAUSE_INTERVAL = 40;
    private static final int MAX_PAUSE_INTERVAL = 80;
    private static final int STUCK_THRESHOLD = 20;
    private static final double REACH_DISTANCE = 1.0;
    private static final double LOOK_AHEAD_DISTANCE = 3.0;
    private final CollectorStationRobotEntity robot;
    private final double speedModifier;
    private final int searchRadius;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private int stateTimer;
    private boolean isFirstTarget = true;
    private boolean isPaused = false;
    private int stuckCounter = 0;
    private int rotationDelay = 0;

    public RandomCollectGoal(CollectorStationRobotEntity robot, double speedModifier, int searchRadius) {
        this.robot = robot;
        this.speedModifier = speedModifier;
        this.searchRadius = searchRadius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.robot.getStatus() == CollectorStationStatus.COLLECTING && this.robot.getStationPos() != null;
    }

    public boolean method_6266() {
        return this.robot.getStatus() == CollectorStationStatus.COLLECTING;
    }

    public void method_6269() {
        this.isFirstTarget = true;
        this.isPaused = false;
        this.stuckCounter = 0;
        this.pickNewTarget();
    }

    public void method_6270() {
        this.robot.method_18800(0.0, this.robot.method_18798().field_1351, 0.0);
        this.robot.method_6125(0.0f);
        this.robot.setMovingFromGoal(false);
        this.robot.setDigging(false);
    }

    public void method_6268() {
        --this.stateTimer;
        if (this.isPaused) {
            this.robot.setMovingFromGoal(false);
            this.robot.setDigging(true);
            this.spawnDiggingParticles();
            if (this.stateTimer <= 0) {
                this.isPaused = false;
                this.robot.setDigging(false);
                this.pickNewTarget();
            }
            return;
        }
        if (this.hasReachedTarget() || this.stateTimer <= 0) {
            this.robot.setMovingFromGoal(false);
            this.startPause();
            return;
        }
        if (this.rotationDelay > 0) {
            --this.rotationDelay;
            this.robot.method_18800(0.0, this.robot.method_18798().field_1351, 0.0);
            this.robot.method_6125(0.0f);
            this.robot.setMovingFromGoal(false);
            this.robot.method_5988().method_20248(this.wantedX, this.wantedY, this.wantedZ);
            return;
        }
        boolean isMoving = ClientSideMovement.moveTowards((class_1308)this.robot, this.wantedX, this.wantedY, this.wantedZ, this.speedModifier * 0.1);
        this.robot.setMovingFromGoal(isMoving);
        if (!isMoving && !this.hasReachedTarget()) {
            ++this.stuckCounter;
            if (this.stuckCounter >= 20) {
                this.stuckCounter = 0;
                this.pickNewTarget();
            }
        } else {
            this.stuckCounter = 0;
            if (isMoving) {
                this.updateLookDirection();
            }
        }
    }

    private void startPause() {
        this.isPaused = true;
        this.stateTimer = 40 + this.robot.method_37908().method_8409().method_43048(40);
        this.robot.method_18800(0.0, this.robot.method_18798().field_1351, 0.0);
        this.robot.method_6125(0.0f);
    }

    private boolean hasReachedTarget() {
        double dz;
        double dx = this.wantedX - this.robot.method_23317();
        return Math.sqrt(dx * dx + (dz = this.wantedZ - this.robot.method_23321()) * dz) < 1.0;
    }

    private void pickNewTarget() {
        class_243 targetPos = this.getRandomPosition();
        if (targetPos != null) {
            this.wantedX = targetPos.field_1352;
            this.wantedY = targetPos.field_1351;
            this.wantedZ = targetPos.field_1350;
            this.rotationDelay = 10;
            this.stateTimer = 100 + this.robot.method_37908().method_8409().method_43048(100);
        }
    }

    private class_243 getRandomPosition() {
        double targetZ;
        double targetX;
        class_2338 stationPos = this.robot.getStationPos();
        if (stationPos == null) {
            return null;
        }
        if (this.isFirstTarget) {
            this.isFirstTarget = false;
            class_2350 facing = this.robot.getFacing();
            double initialDistance = 5.0 + this.robot.method_37908().method_8409().method_43058() * 5.0;
            targetX = (double)stationPos.method_10263() + 0.5 + (double)facing.method_10148() * initialDistance;
            targetZ = (double)stationPos.method_10260() + 0.5 + (double)facing.method_10165() * initialDistance;
        } else {
            double angle = this.robot.method_37908().method_8409().method_43058() * Math.PI * 2.0;
            double distance = 3.0 + this.robot.method_37908().method_8409().method_43058() * ((double)this.searchRadius * 0.7);
            targetX = (double)stationPos.method_10263() + 0.5 + Math.cos(angle) * distance;
            targetZ = (double)stationPos.method_10260() + 0.5 + Math.sin(angle) * distance;
        }
        return ClientSideMovement.findGroundPosition(this.robot.method_37908(), targetX, stationPos.method_10264(), targetZ, 5);
    }

    private void updateLookDirection() {
        this.robot.method_5962().method_6239(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        double dx = this.wantedX - this.robot.method_23317();
        double dy = this.wantedY - this.robot.method_23318();
        double dz = this.wantedZ - this.robot.method_23321();
        double dist = Math.sqrt(dx * dx + dz * dz);
        if (dist > 0.1) {
            double lookX = this.robot.method_23317() + dx / dist * 3.0;
            double lookY = this.robot.method_23320() + Math.max(0.0, dy * 0.3);
            double lookZ = this.robot.method_23321() + dz / dist * 3.0;
            this.robot.method_5988().method_20248(lookX, lookY, lookZ);
        }
    }

    private void spawnDiggingParticles() {
        if (this.robot.method_37908().method_8510() % 5L == 0L) {
            double offsetX = (this.robot.method_37908().method_8409().method_43058() - 0.5) * 0.4;
            double offsetZ = (this.robot.method_37908().method_8409().method_43058() - 0.5) * 0.4;
            this.robot.method_37908().method_8406((class_2394)class_2398.field_11203, this.robot.method_23317() + offsetX, this.robot.method_23318() + 0.1, this.robot.method_23321() + offsetZ, 0.0, 0.02, 0.0);
        }
    }
}

