/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.floatingscrapcollector.FloatingScrapCollectorBlockEntity;
import de.markusbordihn.scraptechworkshop.item.ScrapFilterItem;
import de.markusbordihn.scraptechworkshop.menu.BaseMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.FloatingCollectorOutputSlot;
import de.markusbordihn.scraptechworkshop.menu.slots.ScrapFilterSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FloatingScrapCollectorMenu
extends BaseMenu {
    public static final int NET_SLOT_X = 8;
    public static final int NET_SLOT_Y = 17;
    public static final int OUTPUT_GRID_START_X = 80;
    public static final int OUTPUT_GRID_START_Y = 17;
    public static final int OUTPUT_GRID_COLUMNS = 3;
    public static final int OUTPUT_GRID_ROWS = 3;
    public static final int PLAYER_INVENTORY_START_Y = 84;
    public static final int PROGRESS_BAR_X = 35;
    public static final int PROGRESS_BAR_Y = 17;
    public static final int PROGRESS_BAR_WIDTH = 18;
    public static final int PROGRESS_BAR_HEIGHT = 54;
    public static final int DURABILITY_BAR_X = 8;
    public static final int DURABILITY_BAR_Y = 38;
    public static final int DURABILITY_BAR_WIDTH = 16;
    public static final int DURABILITY_BAR_HEIGHT = 4;
    public static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[FloatingScrapCollectorMenu]";
    public static class_3917<FloatingScrapCollectorMenu> TYPE;
    private final FloatingScrapCollectorBlockEntity blockEntity;
    private final class_1937 level;
    private final class_3913 additionalData;
    private final class_1277 dummyContainer;
    private final class_2338 blockPos;

    public FloatingScrapCollectorMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, FloatingScrapCollectorMenu.getBlockEntityFromData(playerInventory, additionalData), (class_3913)new class_3919(2));
    }

    public FloatingScrapCollectorMenu(int windowId, class_1661 playerInventory, class_2586 entity, class_3913 additionalData) {
        super(TYPE, windowId);
        this.level = playerInventory.field_7546.method_37908();
        this.additionalData = additionalData != null ? additionalData : new class_3919(2);
        this.dummyContainer = new class_1277(10);
        if (entity instanceof FloatingScrapCollectorBlockEntity) {
            FloatingScrapCollectorBlockEntity collectorEntity;
            this.blockEntity = collectorEntity = (FloatingScrapCollectorBlockEntity)entity;
            this.blockPos = collectorEntity.method_11016();
        } else {
            log.error("{} Expected FloatingScrapCollectorBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.method_11016() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        FloatingScrapCollectorMenu.method_17359((class_1263)playerInventory, (int)10);
        this.addCollectorSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 84);
        this.method_17360(this.additionalData);
    }

    private static class_2586 getBlockEntityFromData(class_1661 playerInventory, class_2540 additionalData) {
        class_2338 pos = additionalData.method_10811();
        return playerInventory.field_7546.method_37908().method_8321(pos);
    }

    private void addCollectorSlots() {
        FloatingScrapCollectorBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.method_7621(new ScrapFilterSlot(entityToUse, 0, 8, 17));
            int outputIndex = 1;
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.method_7621(new FloatingCollectorOutputSlot(entityToUse, outputIndex++, 80 + col * 18, 17 + row * 18));
                }
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                this.method_7621(new DummySlot((class_1263)this.dummyContainer, i, -1000, -1000));
            }
        }
    }

    private FloatingScrapCollectorBlockEntity getValidBlockEntity() {
        class_2586 entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.method_8321(this.blockPos)) instanceof FloatingScrapCollectorBlockEntity) {
            FloatingScrapCollectorBlockEntity collectorEntity = (FloatingScrapCollectorBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return collectorEntity;
        }
        return null;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 returnStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            returnStack = slotStack.method_7972();
            if (index < 10) {
                if (!this.method_7616(slotStack, 10, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else if (slotStack.method_7909() instanceof ScrapFilterItem) {
                if (!this.method_7616(slotStack, 0, 1, false)) {
                    return class_1799.field_8037;
                }
            } else {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == returnStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return returnStack;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity == null) {
            return false;
        }
        return FloatingScrapCollectorMenu.method_17695((class_3914)class_3914.method_17392((class_1937)this.level, (class_2338)this.blockEntity.method_11016()), (class_1657)player, (class_2248)this.blockEntity.method_11010().method_26204());
    }

    public int getProgress() {
        return this.additionalData.method_17390(0);
    }

    public int getMaxProgress() {
        return this.additionalData.method_17390(1);
    }

    public int getScaledProgress() {
        int progress = this.getProgress();
        int maxProgress = this.getMaxProgress();
        return maxProgress != 0 && progress != 0 ? progress * 54 / maxProgress : 0;
    }

    public float getNetDurabilityPercent() {
        if (this.blockEntity == null) {
            return 0.0f;
        }
        class_1799 netStack = this.blockEntity.getContainer().method_5438(0);
        if (netStack.method_7960() || !(netStack.method_7909() instanceof ScrapFilterItem)) {
            return 0.0f;
        }
        return ScrapFilterItem.getDurabilityPercent(netStack);
    }

    public FloatingScrapCollectorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

