/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.menu;

import de.markusbordihn.scraptechworkshop.block.entity.windturbine.ScrapWindTurbineBlockEntity;
import de.markusbordihn.scraptechworkshop.block.windturbine.ScrapWindTurbineBlock;
import de.markusbordihn.scraptechworkshop.data.windturbine.ScrapWindTurbineStatus;
import de.markusbordihn.scraptechworkshop.energy.EnergyPowerGenerator;
import de.markusbordihn.scraptechworkshop.menu.EnergyPowerGeneratorMenu;
import de.markusbordihn.scraptechworkshop.menu.slots.DummySlot;
import de.markusbordihn.scraptechworkshop.menu.slots.EnergyCellSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapWindTurbineMenu
extends EnergyPowerGeneratorMenu {
    public static final int CHARGING_BATTERY_SLOT_X = 135;
    public static final int CHARGING_BATTERY_SLOT_Y = 43;
    public static final int PLAYER_INVENTORY_START_Y = 119;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String LOG_PREFIX = "[SCRAP_WIND_TURBINE]";
    private static final int PLAYER_INVENTORY_START_INDEX = 2;
    private static final int PLAYER_INVENTORY_END_INDEX = 29;
    private static final int PLAYER_HOTBAR_END_INDEX = 38;
    private static final int ADDITIONAL_CONTAINER_DATA_SIZE = 2;
    public static class_3917<ScrapWindTurbineMenu> TYPE;
    private final ScrapWindTurbineBlockEntity blockEntity;
    private final class_1937 level;
    private final class_3913 additionalData;
    private final class_1277 dummyContainer;
    private final class_2338 blockPos;

    public ScrapWindTurbineMenu(int windowId, class_1661 playerInventory, class_2540 additionalData) {
        this(windowId, playerInventory, ScrapWindTurbineMenu.getBlockEntityFromData(playerInventory, additionalData), (class_3913)new class_3919(2));
    }

    public ScrapWindTurbineMenu(int windowId, class_1661 playerInventory, class_2586 entity, class_3913 additionalData) {
        class_3919 class_39192;
        if (entity instanceof EnergyPowerGenerator) {
            EnergyPowerGenerator generator = (EnergyPowerGenerator)entity;
            class_39192 = generator.getEnergyPowerData();
        } else {
            class_39192 = new class_3919(2);
        }
        super(TYPE, windowId, (class_3913)class_39192);
        this.level = playerInventory.field_7546.method_37908();
        this.additionalData = additionalData != null ? additionalData : new class_3919(2);
        this.dummyContainer = new class_1277(2);
        if (entity instanceof ScrapWindTurbineBlockEntity) {
            ScrapWindTurbineBlockEntity windTurbineEntity;
            this.blockEntity = windTurbineEntity = (ScrapWindTurbineBlockEntity)entity;
            this.blockPos = windTurbineEntity.method_11016();
        } else {
            log.error("{} Expected ScrapWindTurbineBlockEntity but got {} at {}", (Object)LOG_PREFIX, (Object)entity, entity != null ? entity.method_11016() : "NULL");
            this.blockEntity = null;
            this.blockPos = null;
        }
        ScrapWindTurbineMenu.method_17359((class_1263)playerInventory, (int)2);
        this.addWindTurbineSlots();
        this.addPlayerInventoryAndHotbar(playerInventory, 119);
        this.method_17360(this.additionalData);
    }

    private static class_2586 getBlockEntityFromData(class_1661 playerInventory, class_2540 additionalData) {
        if (additionalData == null) {
            log.error("{} additionalData is NULL", (Object)LOG_PREFIX);
            return null;
        }
        try {
            class_2338 pos = additionalData.method_10811();
            class_1937 level = playerInventory.field_7546.method_37908();
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity == null) {
                log.error("{} BlockEntity is NULL at {}", (Object)LOG_PREFIX, (Object)pos);
                return null;
            }
            return blockEntity;
        }
        catch (Exception e) {
            log.error("{} Error reading BlockEntity from additionalData: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private void addWindTurbineSlots() {
        ScrapWindTurbineBlockEntity entityToUse = this.getValidBlockEntity();
        if (entityToUse != null) {
            this.method_7621(new EnergyCellSlot((class_1263)entityToUse, 0, -20, 6));
            this.method_7621(new EnergyCellSlot((class_1263)entityToUse, 1, 135, 43));
        } else {
            for (int i = 0; i < 2; ++i) {
                this.method_7621(new DummySlot((class_1263)this.dummyContainer, i, -1000, -1000));
            }
            log.warn("{} Using dummy slots because BlockEntity is not available", (Object)LOG_PREFIX);
        }
    }

    private ScrapWindTurbineBlockEntity getValidBlockEntity() {
        class_2586 entity;
        if (this.blockEntity != null) {
            return this.blockEntity;
        }
        if (this.blockPos != null && this.level != null && (entity = this.level.method_8321(this.blockPos)) instanceof ScrapWindTurbineBlockEntity) {
            ScrapWindTurbineBlockEntity windTurbineEntity = (ScrapWindTurbineBlockEntity)entity;
            log.debug("{} Resolved BlockEntity on delayed lookup", (Object)LOG_PREFIX);
            return windTurbineEntity;
        }
        return null;
    }

    public int getWindSpeed() {
        return this.additionalData.method_17390(0);
    }

    public int getPowerGeneration() {
        return this.additionalData.method_17390(1);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotItem = slot.method_7677();
            itemStack = slotItem.method_7972();
            if (index < 2 ? !this.method_7616(slotItem, 2, 38, true) : index < 38 && !this.method_7616(slotItem, 0, 2, false)) {
                return class_1799.field_8037;
            }
            if (slotItem.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity != null && this.blockEntity.method_10997() != null) {
            return ScrapWindTurbineMenu.method_17695((class_3914)class_3914.method_17392((class_1937)this.blockEntity.method_10997(), (class_2338)this.blockEntity.method_11016()), (class_1657)player, (class_2248)this.blockEntity.method_11010().method_26204());
        }
        return false;
    }

    public ScrapWindTurbineBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public ScrapWindTurbineStatus getWindTurbineStatus() {
        if (this.blockEntity == null || this.blockEntity.method_10997() == null) {
            return ScrapWindTurbineStatus.IDLE;
        }
        return (ScrapWindTurbineStatus)((Object)this.blockEntity.method_11010().method_11654(ScrapWindTurbineBlock.STATUS));
    }

    public int getEnergyTabBatterySlotIndex() {
        return 0;
    }

    public int getChargingBatterySlotIndex() {
        return 1;
    }
}

