/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.recipe.recycler;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerByproduct;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerMatch;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerOutput;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerRecipeSerializer
implements class_1865<RecyclerRecipe> {
    public static final RecyclerRecipeSerializer INSTANCE = new RecyclerRecipeSerializer();
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String MATCH_FIELD = "match";
    private static final String PRIMARY_OUTPUT_FIELD = "primary_output";
    private static final String BYPRODUCTS_FIELD = "byproducts";
    private static final String PROCESS_TIME_FIELD = "process_time";
    private static final String WEIGHT_FIELD = "weight";
    private static final String ITEM_FIELD = "item";
    private static final String TAG_FIELD = "tag";
    private static final String COUNT_FIELD = "count";
    private static final String MIN_FIELD = "min";
    private static final String MAX_FIELD = "max";
    private static final String DURABILITY_SCALING_FIELD = "durability_scaling";
    private static final String CHANCE_FIELD = "chance";
    private static final int DEFAULT_WEIGHT = 0;
    private static final int DEFAULT_MIN_COUNT = 1;
    private static final int DEFAULT_MAX_COUNT = 3;
    private static final int DEFAULT_PROCESS_TIME_SECONDS = 10;
    private static final double DEFAULT_CHANCE = 0.0;
    private static final boolean DEFAULT_DURABILITY_SCALING = false;

    private RecyclerRecipeSerializer() {
    }

    public RecyclerRecipe fromJson(class_2960 recipeId, JsonObject json) {
        int processTime;
        JsonObject matchJson = class_3518.method_15296((JsonObject)json, (String)MATCH_FIELD);
        RecyclerMatch match = this.parseMatch(matchJson);
        if (match == null) {
            log.error("Recipe '{}' has invalid match - skipping recipe", (Object)recipeId);
            return null;
        }
        JsonObject primaryOutputJson = class_3518.method_15296((JsonObject)json, (String)PRIMARY_OUTPUT_FIELD);
        RecyclerOutput primaryOutput = this.parseOutput(primaryOutputJson);
        if (primaryOutput == null) {
            log.error("Recipe '{}' has invalid primary output - skipping recipe", (Object)recipeId);
            return null;
        }
        ArrayList<RecyclerByproduct> byproducts = new ArrayList<RecyclerByproduct>();
        if (json.has(BYPRODUCTS_FIELD)) {
            JsonArray byproductsArray = class_3518.method_15261((JsonObject)json, (String)BYPRODUCTS_FIELD);
            for (int i = 0; i < byproductsArray.size(); ++i) {
                JsonObject byproductJson = byproductsArray.get(i).getAsJsonObject();
                RecyclerByproduct byproduct = this.parseByproduct(byproductJson);
                if (byproduct == null) continue;
                byproducts.add(byproduct);
            }
        }
        if ((processTime = class_3518.method_15282((JsonObject)json, (String)PROCESS_TIME_FIELD, (int)10) * 20) < 1) {
            log.error("Process time must be at least 1 tick, got: {} - using default", (Object)(processTime / 20));
            processTime = 200;
        }
        int weight = class_3518.method_15282((JsonObject)json, (String)WEIGHT_FIELD, (int)0);
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    private RecyclerMatch parseMatch(JsonObject matchJson) {
        if (matchJson.has(ITEM_FIELD)) {
            String itemId = class_3518.method_15265((JsonObject)matchJson, (String)ITEM_FIELD);
            class_2960 itemLocation = new class_2960(itemId);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemLocation);
            if (item == null || item == class_1802.field_8162) {
                log.error("Invalid item '{}' in recipe match field - item does not exist", (Object)itemId);
                return null;
            }
            return new RecyclerMatch(item);
        }
        if (matchJson.has(TAG_FIELD)) {
            String tagId = class_3518.method_15265((JsonObject)matchJson, (String)TAG_FIELD);
            class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)new class_2960(tagId));
            return new RecyclerMatch((class_6862<class_1792>)tag);
        }
        log.error("Recipe match must have either 'item' or 'tag' field");
        return null;
    }

    private RecyclerOutput parseOutput(JsonObject outputJson) {
        String itemId = class_3518.method_15265((JsonObject)outputJson, (String)ITEM_FIELD);
        class_2960 itemLocation = new class_2960(itemId);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemLocation);
        if (item == null || item == class_1802.field_8162) {
            log.error("Invalid item '{}' in recipe output field - item does not exist", (Object)itemId);
            return null;
        }
        int minCount = 1;
        int maxCount = 3;
        if (outputJson.has(COUNT_FIELD)) {
            maxCount = class_3518.method_15260((JsonObject)outputJson, (String)COUNT_FIELD);
            minCount = maxCount;
            if (minCount < 1) {
                log.error("Output count must be at least 1, got: {} - using default", (Object)minCount);
                maxCount = 1;
                minCount = 1;
            }
        } else if (outputJson.has(MIN_FIELD) || outputJson.has(MAX_FIELD)) {
            minCount = class_3518.method_15282((JsonObject)outputJson, (String)MIN_FIELD, (int)1);
            maxCount = class_3518.method_15282((JsonObject)outputJson, (String)MAX_FIELD, (int)3);
            if (minCount < 1) {
                log.error("Output min count must be at least 1, got: {} - using default", (Object)minCount);
                minCount = 1;
            }
            if (maxCount < minCount) {
                log.error("Output max count ({}) must be >= min count ({}) - using min as max", (Object)maxCount, (Object)minCount);
                maxCount = minCount;
            }
        }
        boolean durabilityScaling = class_3518.method_15258((JsonObject)outputJson, (String)DURABILITY_SCALING_FIELD, (boolean)false);
        return new RecyclerOutput(item, minCount, maxCount, durabilityScaling);
    }

    private RecyclerByproduct parseByproduct(JsonObject byproductJson) {
        String itemId = class_3518.method_15265((JsonObject)byproductJson, (String)ITEM_FIELD);
        class_2960 itemLocation = new class_2960(itemId);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemLocation);
        if (item == null || item == class_1802.field_8162) {
            log.error("Invalid item '{}' in recipe byproduct field - item does not exist", (Object)itemId);
            return null;
        }
        double chance = class_3518.method_34915((JsonObject)byproductJson, (String)CHANCE_FIELD, (double)0.0);
        if (chance < 0.0 || chance > 1.0) {
            log.error("Byproduct chance must be between 0.0 and 1.0, got: {} - clamping", (Object)chance);
            chance = Math.max(0.0, Math.min(1.0, chance));
        }
        int minCount = 1;
        int maxCount = 1;
        if (byproductJson.has(COUNT_FIELD)) {
            maxCount = class_3518.method_15260((JsonObject)byproductJson, (String)COUNT_FIELD);
            minCount = maxCount;
            if (minCount < 1) {
                log.error("Byproduct count must be at least 1, got: {} - using default", (Object)minCount);
                maxCount = 1;
                minCount = 1;
            }
        } else if (byproductJson.has(MIN_FIELD) || byproductJson.has(MAX_FIELD)) {
            minCount = class_3518.method_15282((JsonObject)byproductJson, (String)MIN_FIELD, (int)1);
            maxCount = class_3518.method_15282((JsonObject)byproductJson, (String)MAX_FIELD, (int)minCount);
            if (minCount < 1) {
                log.error("Byproduct min count must be at least 1, got: {} - using default", (Object)minCount);
                minCount = 1;
            }
            if (maxCount < minCount) {
                log.error("Byproduct max count ({}) must be >= min count ({}) - using min as max", (Object)maxCount, (Object)minCount);
                maxCount = minCount;
            }
        }
        return new RecyclerByproduct(item, chance, minCount, maxCount);
    }

    public RecyclerRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        RecyclerMatch match;
        boolean isItemMatch = buffer.readBoolean();
        if (isItemMatch) {
            class_1792 item = (class_1792)buffer.method_42064((class_2359)class_7923.field_41178);
            match = new RecyclerMatch(item);
        } else {
            class_2960 tagId = buffer.method_10810();
            class_6862 tag = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tagId);
            match = new RecyclerMatch((class_6862<class_1792>)tag);
        }
        class_1792 primaryItem = (class_1792)buffer.method_42064((class_2359)class_7923.field_41178);
        int minCount = buffer.method_10816();
        int maxCount = buffer.method_10816();
        boolean durabilityScaling = buffer.readBoolean();
        RecyclerOutput primaryOutput = new RecyclerOutput(primaryItem, minCount, maxCount, durabilityScaling);
        int byproductCount = buffer.method_10816();
        ArrayList<RecyclerByproduct> byproducts = new ArrayList<RecyclerByproduct>();
        for (int i = 0; i < byproductCount; ++i) {
            class_1792 byproductItem = (class_1792)buffer.method_42064((class_2359)class_7923.field_41178);
            double chance = buffer.readDouble();
            int byproductMin = buffer.method_10816();
            int byproductMax = buffer.method_10816();
            byproducts.add(new RecyclerByproduct(byproductItem, chance, byproductMin, byproductMax));
        }
        int processTime = buffer.method_10816();
        int weight = buffer.method_10816();
        return new RecyclerRecipe(recipeId, match, primaryOutput, byproducts, processTime, weight);
    }

    public void toNetwork(class_2540 buffer, RecyclerRecipe recipe) {
        RecyclerMatch match = recipe.match();
        buffer.writeBoolean(match.isItemMatch());
        if (match.isItemMatch()) {
            buffer.method_42065((class_2359)class_7923.field_41178, (Object)match.getItem());
        } else {
            buffer.method_10812(match.getTag().comp_327());
        }
        RecyclerOutput primaryOutput = recipe.primaryOutput();
        buffer.method_42065((class_2359)class_7923.field_41178, (Object)primaryOutput.getItem());
        buffer.method_10804(primaryOutput.getMinCount());
        buffer.method_10804(primaryOutput.getMaxCount());
        buffer.writeBoolean(primaryOutput.isDurabilityScaling());
        List<RecyclerByproduct> byproducts = recipe.byproducts();
        buffer.method_10804(byproducts.size());
        for (RecyclerByproduct byproduct : byproducts) {
            buffer.method_42065((class_2359)class_7923.field_41178, (Object)byproduct.getItem());
            buffer.writeDouble(byproduct.getChance());
            buffer.method_10804(byproduct.getMinCount());
            buffer.method_10804(byproduct.getMaxCount());
        }
        buffer.method_10804(recipe.processTime());
        buffer.method_10804(recipe.weight());
    }
}

