/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.spawner;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RobotSpawnConfig {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Gson GSON = new Gson();
    public final boolean enabled;
    public final int weight;
    public final int minGroup;
    public final int maxGroup;
    public final String biomes;
    public final int minDistanceFromCenter;
    public final int despawnDistance;

    public RobotSpawnConfig(boolean enabled, int weight, int minGroup, int maxGroup, String biomes, int minDistanceFromCenter, int despawnDistance) {
        this.enabled = enabled;
        this.weight = weight;
        this.minGroup = minGroup;
        this.maxGroup = maxGroup;
        this.biomes = biomes;
        this.minDistanceFromCenter = minDistanceFromCenter;
        this.despawnDistance = despawnDistance;
    }

    public static RobotSpawnConfig load(String resourcePath) {
        try {
            InputStream stream = RobotSpawnConfig.class.getResourceAsStream("/data/scrap_tech_workshop/forge/biome_modifier/" + resourcePath + "_spawn.json");
            if (stream == null) {
                log.warn("Could not find spawn config: {}, using defaults", (Object)resourcePath);
                return RobotSpawnConfig.getDefaults();
            }
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
            int weight = 2;
            int minGroup = 1;
            int maxGroup = 1;
            String biomes = "#minecraft:is_overworld";
            if (json.has("spawners") && json.get("spawners").isJsonArray()) {
                JsonObject spawner = json.getAsJsonArray("spawners").get(0).getAsJsonObject();
                weight = spawner.has("weight") ? spawner.get("weight").getAsInt() : 2;
                minGroup = spawner.has("minCount") ? spawner.get("minCount").getAsInt() : 1;
                int n = maxGroup = spawner.has("maxCount") ? spawner.get("maxCount").getAsInt() : 1;
            }
            if (json.has("biomes")) {
                biomes = json.get("biomes").getAsString();
            }
            return new RobotSpawnConfig(true, weight, minGroup, maxGroup, biomes, json.has("minDistanceFromCenter") ? json.get("minDistanceFromCenter").getAsInt() : 512, json.has("despawnDistance") ? json.get("despawnDistance").getAsInt() : 0);
        }
        catch (Exception e) {
            log.error("Failed to load spawn config: {}, using defaults", (Object)resourcePath, (Object)e);
            return RobotSpawnConfig.getDefaults();
        }
    }

    private static RobotSpawnConfig getDefaults() {
        return new RobotSpawnConfig(true, 2, 1, 1, "#minecraft:is_overworld", 512, 0);
    }
}

