/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.tags;

import de.markusbordihn.scraptechworkshop.data.scrap.ScrapType;
import de.markusbordihn.scraptechworkshop.tags.ModBlockTags;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapTypeBlockTags {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<ScrapType, class_6862<class_2248>> SCRAP_TYPE_TO_TAG_MAP = new EnumMap<ScrapType, class_6862<class_2248>>(ScrapType.class);
    private static final Map<class_2248, ScrapType> BLOCK_TO_SCRAP_TYPE_CACHE = new HashMap<class_2248, ScrapType>();

    private ScrapTypeBlockTags() {
    }

    public static class_6862<class_2248> getBlockTagForScrapType(ScrapType scrapType) {
        return SCRAP_TYPE_TO_TAG_MAP.get((Object)scrapType);
    }

    public static Map<ScrapType, class_6862<class_2248>> getAllScrapTypeBlockTags() {
        return SCRAP_TYPE_TO_TAG_MAP;
    }

    public static ScrapType getScrapTypeForBlock(class_2248 block) {
        return BLOCK_TO_SCRAP_TYPE_CACHE.get(block);
    }

    public static void initializeCache() {
        log.info("{} Initializing Scrap Type Block Tags Cache ...", (Object)"Initialize Scrap Tech Workshop");
        for (Map.Entry<ScrapType, class_6862<class_2248>> entry : SCRAP_TYPE_TO_TAG_MAP.entrySet()) {
            ScrapType scrapType = entry.getKey();
            class_6862<class_2248> tag = entry.getValue();
            for (class_6880 blockHolder : class_7923.field_41175.method_40286(tag)) {
                BLOCK_TO_SCRAP_TYPE_CACHE.put((class_2248)blockHolder.comp_349(), scrapType);
            }
        }
        log.debug("{} Initialized Scrap Type Block Tags Cache with {} entries: {}", (Object)"Initialize Scrap Tech Workshop", (Object)BLOCK_TO_SCRAP_TYPE_CACHE.size(), BLOCK_TO_SCRAP_TYPE_CACHE);
    }

    static {
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.ALLOY, ModBlockTags.SCRAP_DROP_ALLOY);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.BIO, ModBlockTags.SCRAP_DROP_BIO);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.CAPACITOR, ModBlockTags.SCRAP_DROP_CAPACITOR);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.CERAMIC, ModBlockTags.SCRAP_DROP_CERAMIC);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.CIRCUIT, ModBlockTags.SCRAP_DROP_CIRCUIT);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.COIL, ModBlockTags.SCRAP_DROP_COIL);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.COPPER, ModBlockTags.SCRAP_DROP_COPPER);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.CRYSTAL, ModBlockTags.SCRAP_DROP_CRYSTAL);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.ENERGY_CELL, ModBlockTags.SCRAP_DROP_ENERGY_CELL);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.FASTENER, ModBlockTags.SCRAP_DROP_FASTENER);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.FIBER, ModBlockTags.SCRAP_DROP_FIBER);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.GLASS, ModBlockTags.SCRAP_DROP_GLASS);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.GOLD, ModBlockTags.SCRAP_DROP_GOLD);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.INSULATION, ModBlockTags.SCRAP_DROP_INSULATION);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.IRON, ModBlockTags.SCRAP_DROP_IRON);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.LUMINOUS, ModBlockTags.SCRAP_DROP_LUMINOUS);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.METAL, ModBlockTags.SCRAP_DROP_METAL);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.MINERAL, ModBlockTags.SCRAP_DROP_MINERAL);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.PLASTIC, ModBlockTags.SCRAP_DROP_PLASTIC);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.RUBBER, ModBlockTags.SCRAP_DROP_RUBBER);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.TECH, ModBlockTags.SCRAP_DROP_TECH);
        SCRAP_TYPE_TO_TAG_MAP.put(ScrapType.WOOD, ModBlockTags.SCRAP_DROP_WOOD);
    }
}

