/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block;

import de.markusbordihn.scraptechworkshop.config.ScrapPileConfig;
import de.markusbordihn.scraptechworkshop.data.ScrapPileVariant;
import de.markusbordihn.scraptechworkshop.effects.ParticleEffects;
import de.markusbordihn.scraptechworkshop.loot.ScrapLootTables;
import de.markusbordihn.scraptechworkshop.spawner.ScrapPileSpawner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScrapPileBlock
extends class_2248
implements class_3737 {
    public static final String ID = "scrap_pile";
    public static final class_2758 SIZE = class_2758.method_11867((String)"size", (int)1, (int)4);
    public static final class_2754<ScrapPileVariant> VARIANT = class_2754.method_11850((String)"variant", ScrapPileVariant.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final class_265 SHAPE_SIZE_1 = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final class_265 SHAPE_SIZE_2 = class_2248.method_9541((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)4.0, (double)14.5);
    private static final class_265 SHAPE_SIZE_3 = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final class_265 SHAPE_SIZE_4 = class_2248.method_9541((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)4.0, (double)15.5);
    private static final Map<UUID, Long> playerPickupCooldowns = new HashMap<UUID, Long>();

    public ScrapPileBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(1))).method_11657(VARIANT, (Comparable)((Object)ScrapPileVariant.MIXED))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    private static class_265 getShapeForSize(int size) {
        return switch (size) {
            case 2 -> SHAPE_SIZE_2;
            case 3 -> SHAPE_SIZE_3;
            case 4 -> SHAPE_SIZE_4;
            default -> SHAPE_SIZE_1;
        };
    }

    private static boolean isPlayerOnCooldown(class_1657 player) {
        Long lastPickupTime = playerPickupCooldowns.get(player.method_5667());
        return lastPickupTime != null && System.currentTimeMillis() - lastPickupTime < (long)ScrapPileConfig.autoPickupDelayTicks * 50L;
    }

    private static void setPlayerCooldown(class_1657 player) {
        playerPickupCooldowns.put(player.method_5667(), System.currentTimeMillis());
    }

    private void handleScrapCollection(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        int currentSize = (Integer)state.method_11654((class_2769)SIZE);
        ScrapPileVariant variant = (ScrapPileVariant)((Object)state.method_11654(VARIANT));
        class_1799 scrapItem = ScrapLootTables.generateRandomScrap(variant, level.field_9229);
        boolean itemAdded = true;
        if (!scrapItem.method_7960() && !player.method_31548().method_7394(scrapItem)) {
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)scrapItem);
            itemAdded = false;
        }
        ParticleEffects.spawnScrapDustParticles(level, pos);
        level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.5f, 0.8f + level.field_9229.method_43057() * 0.4f);
        int newSize = currentSize - 1;
        if (newSize <= 0) {
            level.method_8650(pos, false);
            try {
                ScrapPileSpawner.decrementChunkCount(new class_1923(pos));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (itemAdded) {
                level.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 0.3f, 1.2f);
            }
        } else {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(newSize)), 3);
        }
    }

    private boolean attemptMergeWithNeighbors(class_1937 level, class_2338 pos, class_2680 state) {
        ScrapPileVariant variant = (ScrapPileVariant)((Object)state.method_11654(VARIANT));
        int currentSize = (Integer)state.method_11654((class_2769)SIZE);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 neighborPos = pos.method_10093(direction);
            class_2680 neighborState = level.method_8320(neighborPos);
            if (!(neighborState.method_26204() instanceof ScrapPileBlock) || neighborState.method_11654(VARIANT) != variant) continue;
            int neighborSize = (Integer)neighborState.method_11654((class_2769)SIZE);
            int totalSize = currentSize + neighborSize;
            if (totalSize <= 4) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(totalSize)), 3);
                level.method_8650(neighborPos, false);
                log.debug("Merged scrap piles at {} and {} in dimension {} - Combined size: {}, Variant: {}", (Object)pos, (Object)neighborPos, (Object)level.method_27983().method_29177(), (Object)totalSize, (Object)variant);
                return true;
            }
            if (totalSize <= 4) continue;
            int overflow = totalSize - 4;
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(4)), 3);
            level.method_8652(neighborPos, (class_2680)neighborState.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(overflow)), 3);
            log.debug("Partially merged scrap piles at {} and {} in dimension {} - Main: 4, Overflow: {}, Variant: {}", (Object)pos, (Object)neighborPos, (Object)level.method_27983().method_29177(), (Object)overflow, (Object)variant);
            return true;
        }
        return false;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_1799 tool = (class_1799)builder.method_51876(class_181.field_1229);
        if (tool != null && ScrapPileConfig.silkTouchEnabled && class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)tool) > 0) {
            return Collections.singletonList(new class_1799((class_1935)this.method_8389()));
        }
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        ScrapPileVariant variant = (ScrapPileVariant)((Object)state.method_11654(VARIANT));
        int size = (Integer)state.method_11654((class_2769)SIZE);
        class_5819 random = class_5819.method_43047();
        int fortuneLevel = 0;
        if (tool != null && ScrapPileConfig.fortuneEnabled) {
            fortuneLevel = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)tool);
        }
        for (int i = 0; i < size; ++i) {
            class_1799 scrap = ScrapLootTables.generateRandomScrap(variant, random);
            if (scrap.method_7960()) continue;
            drops.add(scrap);
            for (int j = 0; j < fortuneLevel; ++j) {
                if (!(random.method_43057() < 0.33f)) continue;
                drops.add(scrap.method_7972());
            }
        }
        return drops;
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return ScrapPileBlock.getShapeForSize((Integer)state.method_11654((class_2769)SIZE));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return ScrapPileBlock.getShapeForSize((Integer)state.method_11654((class_2769)SIZE));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!level.field_9236) {
            if (player.method_5715()) {
                return ScrapPileConfig.autoMergeEnabled && this.attemptMergeWithNeighbors(level, pos, state) ? class_1269.field_5812 : class_1269.field_5811;
            }
            this.handleScrapCollection(level, pos, state, player);
            return class_1269.field_5812;
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (ScrapPileConfig.autoPickupEnabled && (ScrapPileConfig.autoPickupDelayTicks == 0 || !ScrapPileBlock.isPlayerOnCooldown(player))) {
                if ((Integer)state.method_11654((class_2769)SIZE) == 1 || ScrapPileConfig.autoPickupDelayTicks == 0) {
                    while (level.method_8320(pos).method_26204() == this) {
                        this.handleScrapCollection(level, pos, level.method_8320(pos), player);
                    }
                } else {
                    this.handleScrapCollection(level, pos, state, player);
                }
                if (ScrapPileConfig.autoPickupDelayTicks > 0) {
                    ScrapPileBlock.setPlayerCooldown(player);
                }
            }
        }
        super.method_9591(level, pos, state, entity);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(1))).method_11657(VARIANT, (Comparable)((Object)ScrapPileVariant.MIXED))).method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!level.field_9236 && !isMoving && oldState.method_26204() != this && ScrapPileConfig.autoMergeEnabled) {
            level.method_39279(pos, (class_2248)this, 1);
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (ScrapPileConfig.autoMergeEnabled) {
            this.attemptMergeWithNeighbors((class_1937)level, pos, state);
        }
    }

    public boolean method_9542(class_2680 state) {
        return ScrapPileConfig.decayEnabled;
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (ScrapPileConfig.decayEnabled && random.method_43048(ScrapPileConfig.decayChance) == 0) {
            int currentSize = (Integer)state.method_11654((class_2769)SIZE);
            ScrapPileVariant variant = (ScrapPileVariant)((Object)state.method_11654(VARIANT));
            if (currentSize > 1) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)SIZE, (Comparable)Integer.valueOf(currentSize - 1)), 3);
                log.debug("Scrap pile aged at {} in dimension {} - Size reduced from {} to {}, Variant: {}", (Object)pos, (Object)level.method_27983().method_29177(), (Object)currentSize, (Object)(currentSize - 1), (Object)variant);
            } else {
                level.method_8650(pos, false);
                class_1923 chunkPos = new class_1923(pos);
                try {
                    ScrapPileSpawner.decrementChunkCount(chunkPos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.debug("Scrap pile completely decayed at {} in dimension {} - Removed, Variant: {}", (Object)pos, (Object)level.method_27983().method_29177(), (Object)variant);
            }
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SIZE, VARIANT, FACING, WATERLOGGED});
    }
}

