/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.hololog.HoloCubeBlock;
import de.markusbordihn.scraptechworkshop.client.hololog.HolologPlayer;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologParser;
import de.markusbordihn.scraptechworkshop.data.hololog.HolologStatus;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoloCubeBlockEntity
extends class_2586 {
    public static final String ID = "holocube";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String HOLOLOG_ID_TAG = "HolologId";
    private static final String PLAYER_UUID_TAG = "PlayerUUID";
    private static final class_2960 DEFAULT_HOLOLOG = new class_2960("scrap_tech_workshop", "holologs/intro/introduction");
    public static class_2591<HoloCubeBlockEntity> TYPE;
    private class_2960 holologId;
    private UUID playerUUID;
    private UUID currentPlayerId = null;

    public HoloCubeBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, HoloCubeBlockEntity blockEntity) {
        if (!level.field_9236) {
            return;
        }
        HolologStatus status = (HolologStatus)((Object)state.method_11654(HoloCubeBlock.STATUS));
        class_2960 holologId = blockEntity.getHolologId();
        if (status == HolologStatus.PLAYING && holologId != null) {
            if (blockEntity.currentPlayerId == null) {
                class_2960 localizedId = HolologParser.getLocalizedId(holologId);
                Optional<HolologData> holologData = HolologParser.getHololog(localizedId);
                if (holologData.isPresent()) {
                    UUID playerId;
                    HolologPlayer.WorldContext context = new HolologPlayer.WorldContext(level, pos);
                    blockEntity.currentPlayerId = playerId = HolologPlayer.play(holologData.get(), context, text -> {
                        if (class_310.method_1551().field_1724 != null) {
                            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a77[Hololog] \u00a7f" + text)), false);
                        }
                    }, () -> {
                        log.info("Hololog playback finished at {}", (Object)pos);
                        HoloCubeBlock.updateStatus(level, pos, HolologStatus.ENDED);
                    });
                    log.info("Started hololog player with ID: {} at position {}", (Object)playerId, (Object)pos);
                } else {
                    log.error("Failed to load hololog data for: {}", (Object)holologId);
                }
            }
        } else if (status == HolologStatus.PAUSED) {
            if (blockEntity.currentPlayerId != null) {
                HolologPlayer.pause(blockEntity.currentPlayerId);
            }
        } else if (status == HolologStatus.READY) {
            if (blockEntity.currentPlayerId != null) {
                HolologPlayer.stop(blockEntity.currentPlayerId);
                blockEntity.currentPlayerId = null;
            }
        } else if (status == HolologStatus.ENDED && blockEntity.currentPlayerId != null) {
            HolologPlayer.stop(blockEntity.currentPlayerId);
            blockEntity.currentPlayerId = null;
        }
    }

    public void cleanup() {
        if (this.currentPlayerId != null) {
            HolologPlayer.stop(this.currentPlayerId);
            this.currentPlayerId = null;
        }
    }

    public void method_11012() {
        super.method_11012();
        this.cleanup();
    }

    public class_2960 getHolologId() {
        return this.holologId != null ? this.holologId : DEFAULT_HOLOLOG;
    }

    public void setHolologId(class_2960 holologId) {
        log.debug("Setting hololog ID for HoloCube at {} to: {}", (Object)this.field_11867, (Object)holologId);
        this.holologId = holologId;
        this.method_5431();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.method_5431();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545(HOLOLOG_ID_TAG)) {
            try {
                this.holologId = new class_2960(tag.method_10558(HOLOLOG_ID_TAG));
            }
            catch (Exception e) {
                log.warn("Failed to load hololog ID from NBT: {}", (Object)e.getMessage());
                this.holologId = DEFAULT_HOLOLOG;
            }
        }
        if (tag.method_10545(PLAYER_UUID_TAG)) {
            this.playerUUID = tag.method_25926(PLAYER_UUID_TAG);
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.holologId != null) {
            tag.method_10582(HOLOLOG_ID_TAG, this.holologId.toString());
        }
        if (this.playerUUID != null) {
            tag.method_25927(PLAYER_UUID_TAG, this.playerUUID);
        }
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    private void syncToClient() {
        class_1937 currentLevel = this.field_11863;
        if (currentLevel != null && !currentLevel.field_9236) {
            currentLevel.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }
}

