/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.block.entity;

import de.markusbordihn.scraptechworkshop.block.RecyclerBlock;
import de.markusbordihn.scraptechworkshop.config.RecyclerConfig;
import de.markusbordihn.scraptechworkshop.data.recycler.RecyclerStatus;
import de.markusbordihn.scraptechworkshop.menu.RecyclerMenu;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipe;
import de.markusbordihn.scraptechworkshop.recipe.recycler.RecyclerRecipeSelector;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecyclerBlockEntity
extends class_2586
implements class_3908,
class_1278 {
    public static final int INPUT_SLOTS = 1;
    public static final int OUTPUT_SLOTS = 9;
    public static final int UPGRADE_SLOTS = 2;
    public static final int TOTAL_SLOTS = 12;
    public static final int INPUT_SLOT = 0;
    public static final int FIRST_OUTPUT_SLOT = 1;
    public static final int LAST_OUTPUT_SLOT = 9;
    public static final String ID = "recycler";
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String NO_RECIPE_TIMER_TAG = "NoRecipeTimer";
    private static final String DONE_TIMER_TAG = "DoneTimer";
    private static final String ITEM_TAG_PREFIX = "Item";
    private static final int PROGRESS_DATA_INDEX = 0;
    private static final int MAX_PROGRESS_DATA_INDEX = 1;
    private static final String TRANSLATION_KEY = "container.scrap_tech_workshop.recycler";
    private static final int NO_RECIPE_COOLDOWN = 40;
    private static final int DONE_DISPLAY_TIME = 20;
    public static class_2591<RecyclerBlockEntity> TYPE;
    private final class_1799[] items = new class_1799[12];
    private int progress = 0;
    private int maxProgress = RecyclerConfig.processTime;
    private final class_3913 containerData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> RecyclerBlockEntity.this.progress;
                case 1 -> RecyclerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    RecyclerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    RecyclerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int noRecipeTimer = 0;
    private int doneTimer = 0;
    private RecyclerRecipe currentRecipe = null;
    private int tickCounter = 0;

    public RecyclerBlockEntity(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
        Arrays.fill(this.items, class_1799.field_8037);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, RecyclerBlockEntity blockEntity) {
        TickResult result;
        if (level.field_9236) {
            return;
        }
        ++blockEntity.tickCounter;
        RecyclerStatus currentStatus = (RecyclerStatus)((Object)state.method_11654(RecyclerBlock.STATUS));
        switch (currentStatus) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NO_RECIPE: {
                TickResult tickResult = blockEntity.handleNoRecipeStatus();
                break;
            }
            case DONE: {
                TickResult tickResult = blockEntity.handleDoneStatus();
                break;
            }
            case IDLE: 
            case WORKING: 
            case ERROR: {
                TickResult tickResult = result = blockEntity.handleActiveStatus(level, pos, state);
            }
        }
        if (result.newStatus != currentStatus) {
            RecyclerBlock.updateStatus(level, pos, result.newStatus);
        }
        if (result.hasChanged && blockEntity.tickCounter % RecyclerConfig.progressUpdateInterval == 0) {
            blockEntity.method_5431();
        }
    }

    private TickResult handleNoRecipeStatus() {
        --this.noRecipeTimer;
        if (this.noRecipeTimer <= 0) {
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.NO_RECIPE, false);
    }

    private TickResult handleDoneStatus() {
        --this.doneTimer;
        if (this.doneTimer <= 0) {
            this.currentRecipe = this.findRecipe();
            if (this.currentRecipe != null && this.canProcessCurrentRecipe()) {
                this.progress = 0;
                return new TickResult(RecyclerStatus.WORKING, true);
            }
            return new TickResult(RecyclerStatus.IDLE, true);
        }
        return new TickResult(RecyclerStatus.DONE, false);
    }

    private TickResult handleActiveStatus(class_1937 level, class_2338 pos, class_2680 state) {
        boolean hasChanged = false;
        RecyclerStatus newStatus = (RecyclerStatus)((Object)state.method_11654(RecyclerBlock.STATUS));
        if (this.currentRecipe == null || !this.canProcessCurrentRecipe()) {
            this.currentRecipe = this.findRecipe();
            if (this.currentRecipe == null && !this.getInputStack().method_7960()) {
                this.ejectInputItem(level, pos, state);
                this.noRecipeTimer = 40;
                return new TickResult(RecyclerStatus.NO_RECIPE, true);
            }
            this.progress = 0;
            hasChanged = true;
        }
        if (this.currentRecipe != null && this.canProcessCurrentRecipe()) {
            ++this.progress;
            newStatus = RecyclerStatus.WORKING;
            hasChanged = true;
            if (this.progress >= this.maxProgress) {
                this.processRecipe();
                this.progress = 0;
                this.currentRecipe = null;
                newStatus = RecyclerStatus.DONE;
                this.doneTimer = 20;
            }
        } else if (this.currentRecipe != null && !this.canProcessCurrentRecipe()) {
            class_1799 inputStack = this.getInputStack();
            newStatus = !inputStack.method_7960() && this.currentRecipe.matchesInput(inputStack) ? RecyclerStatus.ERROR : RecyclerStatus.IDLE;
            this.progress = 0;
            hasChanged = true;
        } else if (this.progress > 0) {
            if (this.findRecipe() == null) {
                newStatus = RecyclerStatus.IDLE;
            }
            this.progress = Math.max(0, this.progress - 2);
            hasChanged = true;
            if (this.progress == 0) {
                newStatus = RecyclerStatus.IDLE;
            }
        } else {
            newStatus = RecyclerStatus.IDLE;
        }
        return new TickResult(newStatus, hasChanged);
    }

    private RecyclerRecipe findRecipe() {
        if (this.field_11863 == null || this.getInputStack().method_7960()) {
            return null;
        }
        class_1799 inputStack = this.getInputStack();
        RecyclerRecipe recipe = RecyclerRecipeSelector.selectBestRecipe(this.field_11863, inputStack).orElse(null);
        if (recipe == null) {
            log.debug("No recycler recipe found for item: {} ({})", (Object)inputStack.method_7909(), (Object)inputStack.method_7909().method_7876());
        }
        return recipe;
    }

    private boolean canProcessCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        class_1799 inputStack = this.getInputStack();
        if (inputStack.method_7960()) {
            return false;
        }
        if (!this.currentRecipe.matchesInput(inputStack)) {
            return false;
        }
        return this.canInsertOutputs(this.currentRecipe.getOutputsForInput(inputStack));
    }

    private void processRecipe() {
        if (this.currentRecipe == null || this.field_11863 == null) {
            return;
        }
        class_1799 inputStack = this.getInputStack();
        if (inputStack.method_7960()) {
            return;
        }
        List<class_1799> outputs = this.currentRecipe.getOutputsForInput(inputStack);
        outputs.forEach(this::insertOutput);
        inputStack.method_7934(1);
        this.method_5431();
        log.debug("Processed item with recipe: {} -> {} outputs", (Object)inputStack.method_7909(), (Object)outputs.size());
    }

    private void ejectInputItem(class_1937 level, class_2338 pos, class_2680 state) {
        class_1799 inputStack = this.getInputStack();
        if (inputStack.method_7960()) {
            return;
        }
        class_2350 backDirection = ((class_2350)state.method_11654((class_2769)RecyclerBlock.FACING)).method_10153();
        class_2338 ejectPos = pos.method_10093(backDirection);
        class_1799 itemToEject = inputStack.method_7972();
        itemToEject.method_7939(1);
        this.getInputStack().method_7934(1);
        class_1264.method_5449((class_1937)level, (double)((double)ejectPos.method_10263() + 0.5), (double)((double)ejectPos.method_10264() + 0.5), (double)((double)ejectPos.method_10260() + 0.5), (class_1799)itemToEject);
        log.debug("Ejected item (no recipe): {} at position {}", (Object)itemToEject.method_7909(), (Object)ejectPos);
        this.addEjectionFeedback(level, pos, ejectPos);
        this.method_5431();
    }

    private void addEjectionFeedback(class_1937 level, class_2338 recyclerPos, class_2338 ejectPos) {
        if (level.field_9236) {
            return;
        }
        level.method_8396(null, recyclerPos, class_3417.field_14701, class_3419.field_15245, 0.5f, 1.2f);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_14199((class_2394)class_2398.field_11251, (double)ejectPos.method_10263() + 0.5, (double)ejectPos.method_10264() + 0.5, (double)ejectPos.method_10260() + 0.5, 3, 0.2, 0.1, 0.2, 0.02);
        }
    }

    private class_1799 getInputStack() {
        return this.method_5438(0);
    }

    private boolean canInsertOutputs(List<class_1799> outputs) {
        class_1799[] simulatedItems = new class_1799[12];
        for (int i = 0; i < 12; ++i) {
            simulatedItems[i] = this.items[i].method_7972();
        }
        for (class_1799 output : outputs) {
            if (this.tryInsertOutput(simulatedItems, output, true)) continue;
            return false;
        }
        return true;
    }

    private boolean tryInsertOutput(class_1799[] itemArray, class_1799 output, boolean isSimulation) {
        class_1799 remaining = output.method_7972();
        for (int i = 1; i <= 9 && !remaining.method_7960(); ++i) {
            class_1799 slotStack = itemArray[i];
            if (slotStack.method_7960()) {
                itemArray[i] = remaining.method_7972();
                remaining = class_1799.field_8037;
                continue;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)remaining)) continue;
            int maxStackSize = slotStack.method_7914();
            int canAdd = maxStackSize - slotStack.method_7947();
            int toAdd = Math.min(canAdd, remaining.method_7947());
            if (isSimulation) {
                slotStack.method_7933(toAdd);
            } else {
                slotStack.method_7933(toAdd);
            }
            remaining.method_7934(toAdd);
        }
        return remaining.method_7960();
    }

    private void insertOutput(class_1799 output) {
        this.tryInsertOutput(this.items, output, false);
    }

    public void method_11014(class_2487 compoundTag) {
        super.method_11014(compoundTag);
        for (int i = 0; i < 12; ++i) {
            this.items[i] = compoundTag.method_10545(ITEM_TAG_PREFIX + i) ? class_1799.method_7915((class_2487)compoundTag.method_10562(ITEM_TAG_PREFIX + i)) : class_1799.field_8037;
        }
        this.progress = compoundTag.method_10550(PROGRESS_TAG);
        this.maxProgress = compoundTag.method_10550(MAX_PROGRESS_TAG);
        this.noRecipeTimer = compoundTag.method_10550(NO_RECIPE_TIMER_TAG);
        this.doneTimer = compoundTag.method_10550(DONE_TIMER_TAG);
    }

    protected void method_11007(class_2487 compoundTag) {
        super.method_11007(compoundTag);
        for (int i = 0; i < 12; ++i) {
            if (this.items[i].method_7960()) continue;
            compoundTag.method_10566(ITEM_TAG_PREFIX + i, (class_2520)this.items[i].method_7953(new class_2487()));
        }
        compoundTag.method_10569(PROGRESS_TAG, this.progress);
        compoundTag.method_10569(MAX_PROGRESS_TAG, this.maxProgress);
        compoundTag.method_10569(NO_RECIPE_TIMER_TAG, this.noRecipeTimer);
        compoundTag.method_10569(DONE_TIMER_TAG, this.doneTimer);
    }

    public int method_5439() {
        return 12;
    }

    public boolean method_5442() {
        for (class_1799 item : this.items) {
            if (item.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        if (slot < 0 || slot >= 12) {
            return class_1799.field_8037;
        }
        return this.items[slot];
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot < 0 || slot >= 12 || this.items[slot].method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 result = this.items[slot].method_7971(amount);
        if (this.items[slot].method_7960()) {
            this.items[slot] = class_1799.field_8037;
        }
        this.method_5431();
        return result;
    }

    public class_1799 method_5441(int slot) {
        if (slot < 0 || slot >= 12) {
            return class_1799.field_8037;
        }
        class_1799 result = this.items[slot];
        this.items[slot] = class_1799.field_8037;
        return result;
    }

    public void method_5447(int slot, class_1799 itemStack) {
        if (slot >= 0 && slot < 12) {
            this.items[slot] = itemStack;
            if (!itemStack.method_7960() && itemStack.method_7947() > this.method_5444()) {
                itemStack.method_7939(this.method_5444());
            }
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public boolean method_5437(int slot, class_1799 itemStack) {
        return slot == 0;
    }

    public void method_5448() {
        for (int i = 0; i < 12; ++i) {
            this.items[i] = class_1799.field_8037;
        }
        this.method_5431();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)TRANSLATION_KEY);
    }

    public class_1703 createMenu(int windowId, class_1661 playerInventory, class_1657 player) {
        return new RecyclerMenu(windowId, playerInventory, this, this.containerData);
    }

    public int getRedstoneSignal() {
        if (this.maxProgress <= 0) {
            return 0;
        }
        return this.progress * 15 / this.maxProgress;
    }

    public class_3913 getContainerData() {
        return this.containerData;
    }

    private void syncToClient() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        this.syncToClient();
    }

    public class_2487 method_16887() {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag);
        return compoundTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11036) {
            return new int[]{0};
        }
        if (direction == class_2350.field_11033 || direction == this.getBackDirection()) {
            return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 itemStack, class_2350 direction) {
        return slot == 0 && direction == class_2350.field_11036;
    }

    public boolean method_5493(int slot, class_1799 itemStack, class_2350 direction) {
        return slot >= 1 && slot <= 9 && (direction == class_2350.field_11033 || direction == this.getBackDirection());
    }

    private class_2350 getBackDirection() {
        if (this.method_11010().method_26204() instanceof RecyclerBlock) {
            return ((class_2350)this.method_11010().method_11654((class_2769)RecyclerBlock.FACING)).method_10153();
        }
        return class_2350.field_11043;
    }

    private static class TickResult {
        final RecyclerStatus newStatus;
        final boolean hasChanged;

        TickResult(RecyclerStatus newStatus, boolean hasChanged) {
            this.newStatus = newStatus;
            this.hasChanged = hasChanged;
        }
    }
}

