/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.scraptechworkshop.client.hololog;

import de.markusbordihn.scraptechworkshop.data.hololog.HolologData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

public class HolologPlayer {
    private static final Logger log = LogManager.getLogger((String)"Scrap Tech Workshop");
    private static final Map<UUID, HolologPlayer> ACTIVE_PLAYERS = new HashMap<UUID, HolologPlayer>();
    private final HolologData hololog;
    private final PlaybackContext context;
    private final Consumer<String> textDisplay;
    private final Runnable onComplete;
    private PlaybackState state = PlaybackState.STOPPED;
    private int currentTick = 0;
    private int currentLine = 0;
    private boolean endEffectsPlayed = false;

    private HolologPlayer(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay, Runnable onComplete) {
        this.hololog = hololog;
        this.context = context;
        this.textDisplay = textDisplay;
        this.onComplete = onComplete;
    }

    public static UUID play(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay) {
        return HolologPlayer.play(hololog, context, textDisplay, null);
    }

    public static UUID play(HolologData hololog, PlaybackContext context, Consumer<String> textDisplay, Runnable onComplete) {
        log.info("Starting hololog playback: {}", (Object)hololog.id());
        UUID id = UUID.randomUUID();
        HolologPlayer player = new HolologPlayer(hololog, context, textDisplay, onComplete);
        ACTIVE_PLAYERS.put(id, player);
        player.start();
        return id;
    }

    public static void stop(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.remove(id);
        if (player != null) {
            player.state = PlaybackState.STOPPED;
        }
    }

    public static void pause(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.get(id);
        if (player != null && player.state == PlaybackState.PLAYING) {
            player.state = PlaybackState.PAUSED;
        }
    }

    public static void resume(UUID id) {
        HolologPlayer player = ACTIVE_PLAYERS.get(id);
        if (player != null && player.state == PlaybackState.PAUSED) {
            player.state = PlaybackState.PLAYING;
        }
    }

    public static int getCurrentLine(class_2960 holologId) {
        for (HolologPlayer player : ACTIVE_PLAYERS.values()) {
            if (!player.hololog.id().equals((Object)holologId)) continue;
            return player.currentLine;
        }
        return -1;
    }

    public static void stopAll() {
        for (HolologPlayer player : ACTIVE_PLAYERS.values()) {
            player.state = PlaybackState.STOPPED;
        }
        ACTIVE_PLAYERS.clear();
    }

    public static void tickAll() {
        ACTIVE_PLAYERS.values().removeIf(player -> {
            if (player.state == PlaybackState.PLAYING) {
                player.tick();
            }
            return player.state == PlaybackState.STOPPED && player.endEffectsPlayed;
        });
    }

    private void start() {
        this.state = PlaybackState.PLAYING;
        this.currentTick = 0;
        this.currentLine = 0;
        this.endEffectsPlayed = false;
        this.playEffects(this.hololog.start());
        if (this.textDisplay != null) {
            Object titleText = class_2561.method_43470((String)this.hololog.title()).getString();
            if (!this.hololog.subtitle().isEmpty()) {
                titleText = (String)titleText + " - " + this.hololog.subtitle();
            }
            this.textDisplay.accept((String)titleText);
        }
    }

    private void tick() {
        if (this.state != PlaybackState.PLAYING) {
            return;
        }
        class_1937 level = this.context.getLevel();
        if (level == null || !(level instanceof class_638)) {
            this.state = PlaybackState.STOPPED;
            return;
        }
        ++this.currentTick;
        if (this.currentLine < this.hololog.lines().size()) {
            HolologData.HolologLine line = this.hololog.lines().get(this.currentLine);
            if (this.currentTick % this.hololog.lineDelayTicks() == 0) {
                if (this.textDisplay != null) {
                    this.textDisplay.accept(line.text());
                }
                this.playEffects(line.effects());
                ++this.currentLine;
            }
        }
        if (this.currentLine >= this.hololog.lines().size()) {
            if (!this.endEffectsPlayed) {
                this.playEffects(this.hololog.end());
                this.endEffectsPlayed = true;
                if (this.onComplete != null) {
                    log.info("Hololog playback completed: {}", (Object)this.hololog.id());
                    this.onComplete.run();
                }
            }
            this.state = PlaybackState.STOPPED;
        }
    }

    private void playEffects(HolologData.HolologEffects effects) {
        if (!(this.context.getLevel() instanceof class_638)) {
            return;
        }
        class_243 effectPos = this.context.getEffectPosition();
        for (HolologData.HolologSound sound : effects.sfx()) {
            this.context.playSound(sound.id(), sound.volume(), sound.pitch());
        }
        for (HolologData.HolologParticle particle : effects.fx()) {
            this.spawnParticles(particle, effectPos);
        }
    }

    private void spawnParticles(HolologData.HolologParticle particle, class_243 pos) {
        class_2394 particleType = this.getParticleType(particle);
        for (int i = 0; i < particle.count(); ++i) {
            class_243 spawnPos = pos.method_1031((Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            this.context.spawnParticle(particleType, spawnPos, new class_243((Math.random() - 0.5) * 0.02, Math.random() * 0.05, (Math.random() - 0.5) * 0.02));
        }
    }

    private class_2394 getParticleType(HolologData.HolologParticle particle) {
        String particleId = particle.id().method_12832();
        if (particleId.equals("dust") && particle.color() != null) {
            Vector3f color = this.parseColor(particle.color());
            return new class_2390(color, particle.scale());
        }
        return switch (particleId) {
            case "smoke" -> class_2398.field_11251;
            case "portal" -> class_2398.field_11214;
            case "crit" -> class_2398.field_11205;
            case "flash" -> class_2398.field_17909;
            default -> class_2398.field_11207;
        };
    }

    private Vector3f parseColor(String hexColor) {
        try {
            int color = Integer.parseInt(hexColor.replace("#", ""), 16);
            float r = (float)class_5253.class_5254.method_27765((int)(color | 0xFF000000)) / 255.0f;
            float g = (float)class_5253.class_5254.method_27766((int)(color | 0xFF000000)) / 255.0f;
            float b = (float)class_5253.class_5254.method_27767((int)(color | 0xFF000000)) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (NumberFormatException e) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }

    public float getProgress() {
        if (this.hololog.lines().isEmpty()) {
            return 1.0f;
        }
        return (float)this.currentLine / (float)this.hololog.lines().size();
    }

    public boolean isActive() {
        return this.state != PlaybackState.STOPPED;
    }

    private static enum PlaybackState {
        STOPPED,
        PLAYING,
        PAUSED;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PlaybackContext {
        public class_1937 getLevel();

        public class_243 getEffectPosition();

        default public void spawnParticle(class_2394 particle, class_243 pos, class_243 speed) {
            class_1937 class_19372 = this.getLevel();
            if (class_19372 instanceof class_638) {
                class_638 clientLevel = (class_638)class_19372;
                clientLevel.method_8406(particle, pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
            }
        }

        default public void playSound(class_2960 soundId, float volume, float pitch) {
            class_3414 sound = class_3414.method_47908((class_2960)soundId);
            class_243 pos = this.getEffectPosition();
            this.getLevel().method_8486(pos.field_1352, pos.field_1351, pos.field_1350, sound, class_3419.field_15245, volume, pitch, false);
        }
    }

    public record UIContext(class_1937 level, class_243 position) implements PlaybackContext
    {
        @Override
        public class_1937 getLevel() {
            return this.level;
        }

        @Override
        public class_243 getEffectPosition() {
            return this.position;
        }
    }

    public record WorldContext(class_1937 level, class_2338 blockPos) implements PlaybackContext
    {
        @Override
        public class_1937 getLevel() {
            return this.level;
        }

        @Override
        public class_243 getEffectPosition() {
            return class_243.method_24953((class_2382)this.blockPos).method_1031(0.0, 0.75, 0.0);
        }
    }
}

